/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.action.interact;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.level.LevelAwareHandler;
import team.creative.littletiles.common.action.LittleInteraction;
import team.creative.littletiles.common.packet.action.LittleInteractionPacket;

public class LittleInteractionHandlerClient
implements LevelAwareHandler {
    private int index;
    private LittleInteraction interaction;

    public LittleInteractionHandlerClient() {
        MinecraftForge.EVENT_BUS.addListener(this::clientTick);
    }

    public boolean start(boolean rightclick) {
        if (this.interaction == null) {
            this.interaction = new LittleInteraction(this.index++, rightclick);
            LittleTiles.NETWORK.sendToServer((CreativePacket)new LittleInteractionPacket(this.interaction, true));
            return true;
        }
        return false;
    }

    public boolean can() {
        return this.interaction == null;
    }

    public void finish() {
        LittleTiles.NETWORK.sendToServer((CreativePacket)new LittleInteractionPacket(this.interaction, false));
        this.interaction = null;
    }

    public void clientTick(TickEvent.RenderTickEvent event) {
        if (this.interaction != null) {
            this.finish();
        }
    }

    @Override
    public void unload() {
        this.interaction = null;
    }
}

