/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.NotNull;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.client.render.model.CreativeBlockModel;
import team.creative.creativecore.client.render.model.CreativeItemBoxModel;
import team.creative.creativecore.client.render.model.CreativeItemModel;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.client.action.interact.LittleInteractionHandlerClient;
import team.creative.littletiles.client.level.LevelHandlersClient;
import team.creative.littletiles.client.level.LittleAnimationHandlerClient;
import team.creative.littletiles.client.level.LittleVanillaInteractionHandlerClient;
import team.creative.littletiles.client.mod.oculus.OculusManager;
import team.creative.littletiles.client.mod.rubidium.RubidiumManager;
import team.creative.littletiles.client.player.LittleClientPlayerConnection;
import team.creative.littletiles.client.render.block.BETilesRenderer;
import team.creative.littletiles.client.render.block.LittleBlockClientRegistry;
import team.creative.littletiles.client.render.cache.build.RenderingThread;
import team.creative.littletiles.client.render.entity.LittleEntityRenderer;
import team.creative.littletiles.client.render.entity.LittleSitRenderer;
import team.creative.littletiles.client.render.entity.RenderSizedTNTPrimed;
import team.creative.littletiles.client.render.item.ItemRenderCache;
import team.creative.littletiles.client.render.item.LittleModelItemBackground;
import team.creative.littletiles.client.render.item.LittleModelItemPreview;
import team.creative.littletiles.client.render.item.LittleModelItemTilesBig;
import team.creative.littletiles.client.render.level.LittleClientEventHandler;
import team.creative.littletiles.client.render.overlay.LittleTilesProfilerOverlay;
import team.creative.littletiles.client.render.overlay.OverlayRenderer;
import team.creative.littletiles.client.render.overlay.PreviewRenderer;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.ingredient.ColorIngredient;
import team.creative.littletiles.common.item.ItemBlockIngredient;
import team.creative.littletiles.common.item.ItemColorIngredient;
import team.creative.littletiles.common.item.ItemLittleChisel;
import team.creative.littletiles.common.item.ItemLittleGlove;
import team.creative.littletiles.common.item.ItemLittlePaintBrush;
import team.creative.littletiles.common.item.ItemPremadeStructure;
import team.creative.littletiles.common.item.glove.GloveMode;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

@OnlyIn(value=Dist.CLIENT)
public class LittleTilesClient {
    public static final Minecraft mc = Minecraft.m_91087_();
    public static final IKeyConflictContext LITTLE_KEY_CONTEXT = new IKeyConflictContext(){

        public boolean isActive() {
            return true;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    };
    public static final LevelHandlersClient LEVEL_HANDLERS = new LevelHandlersClient();
    public static LittleActionHandlerClient ACTION_HANDLER;
    public static LittleAnimationHandlerClient ANIMATION_HANDLER;
    public static LittleVanillaInteractionHandlerClient INTERACTION_HANDLER;
    public static LittleInteractionHandlerClient INTERACTION;
    public static PreviewRenderer PREVIEW_RENDERER;
    public static ItemRenderCache ITEM_RENDER_CACHE;
    public static LittleClientPlayerConnection PLAYER_CONNECTION;
    public static OverlayRenderer OVERLAY_RENDERER;
    public static KeyMapping mirror;
    public static KeyMapping mark;
    public static KeyMapping configure;
    public static KeyMapping up;
    public static KeyMapping down;
    public static KeyMapping right;
    public static KeyMapping left;
    public static KeyMapping undo;
    public static KeyMapping redo;
    public static BETilesRenderer blockEntityRenderer;

    public static void grid(LittleGrid grid) {
        LittleTilesClient.ACTION_HANDLER.setting.grid(grid);
    }

    public static void placementMode(PlacementMode mode) {
        LittleTilesClient.ACTION_HANDLER.setting.placementMode(mode);
    }

    public static void setPlace(LittleGrid grid, PlacementMode mode) {
        LittleTilesClient.ACTION_HANDLER.setting.set(grid, mode);
    }

    public static Component arrowKeysTooltip() {
        if (up.m_90864_() && down.m_90864_() && right.m_90864_() && left.m_90864_()) {
            return Component.m_237115_((String)"gui.tooltip.arrow_keys");
        }
        return Component.m_237119_().m_7220_(up.m_90863_()).m_130946_(", ").m_7220_(down.m_90863_()).m_130946_(", ").m_7220_(right.m_90863_()).m_130946_(", ").m_7220_(left.m_90863_());
    }

    public static void displayActionMessage(List<Component> message) {
        OVERLAY_RENDERER.displayActionMessage(message);
    }

    public static void load(IEventBus bus) {
        bus.addListener(LittleTilesClient::setup);
        MinecraftForge.EVENT_BUS.addListener(LittleTilesClient::commands);
        bus.addListener(LittleTilesClient::initItemColors);
        bus.addListener(LittleTilesClient::initBlockColors);
        bus.addListener(LittleTilesClient::registerKeys);
        bus.addListener(LittleTilesClient::modelEvent);
        bus.addListener(LittleTilesClient::modelLoader);
    }

    private static void registerKeys(RegisterKeyMappingsEvent event) {
        up = new LittleKeyMapping("key.rotateup", LITTLE_KEY_CONTEXT, 265, "key.categories.littletiles").ignoreModifier();
        down = new LittleKeyMapping("key.rotatedown", LITTLE_KEY_CONTEXT, 264, "key.categories.littletiles").ignoreModifier();
        right = new LittleKeyMapping("key.rotateright", LITTLE_KEY_CONTEXT, 262, "key.categories.littletiles").ignoreModifier();
        left = new LittleKeyMapping("key.rotateleft", LITTLE_KEY_CONTEXT, 263, "key.categories.littletiles").ignoreModifier();
        mirror = new LittleKeyMapping("key.little.mirror", LITTLE_KEY_CONTEXT, 71, "key.categories.littletiles");
        mark = new LittleKeyMapping("key.little.mark", LITTLE_KEY_CONTEXT, 77, "key.categories.littletiles");
        configure = new LittleKeyMapping("key.little.config.item", LITTLE_KEY_CONTEXT, 67, "key.categories.littletiles");
        undo = new LittleKeyMapping("key.little.undo", LITTLE_KEY_CONTEXT, KeyModifier.CONTROL, 90, "key.categories.littletiles");
        redo = new LittleKeyMapping("key.little.redo", LITTLE_KEY_CONTEXT, KeyModifier.CONTROL, 89, "key.categories.littletiles");
        event.register(up);
        event.register(down);
        event.register(right);
        event.register(left);
        event.register(mirror);
        event.register(mark);
        event.register(configure);
        event.register(undo);
        event.register(redo);
    }

    private static void setup(FMLClientSetupEvent event) {
        mc.getItemColors().m_92689_((stack, layer) -> {
            if (layer == 0) {
                return -1;
            }
            return ItemLittlePaintBrush.getColor(stack);
        }, new ItemLike[]{(ItemLike)LittleTilesRegistry.PAINT_BRUSH.get()});
        MinecraftForge.EVENT_BUS.register((Object)new LittleClientEventHandler());
        LEVEL_HANDLERS.register(LittleActionHandlerClient::new, x -> {
            ACTION_HANDLER = x;
        });
        LEVEL_HANDLERS.register(LittleVanillaInteractionHandlerClient::new, x -> {
            INTERACTION_HANDLER = x;
        });
        LEVEL_HANDLERS.register(LittleTiles.ANIMATION_HANDLERS::get, x -> {
            ANIMATION_HANDLER = (LittleAnimationHandlerClient)x;
        });
        PREVIEW_RENDERER = new PreviewRenderer();
        LEVEL_HANDLERS.register(PREVIEW_RENDERER);
        ITEM_RENDER_CACHE = new ItemRenderCache();
        LEVEL_HANDLERS.register(ITEM_RENDER_CACHE);
        PLAYER_CONNECTION = new LittleClientPlayerConnection();
        LEVEL_HANDLERS.register(PLAYER_CONNECTION);
        INTERACTION = new LittleInteractionHandlerClient();
        LEVEL_HANDLERS.register(INTERACTION);
        MinecraftForge.EVENT_BUS.register(LittleTilesProfilerOverlay.class);
        OVERLAY_RENDERER = new OverlayRenderer();
        LEVEL_HANDLERS.register(OVERLAY_RENDERER);
        ReloadableResourceManager reloadableResourceManager = (ReloadableResourceManager)mc.m_91098_();
        reloadableResourceManager.m_7217_((PreparableReloadListener)new ResourceManagerReloadListener(){

            public void m_6213_(ResourceManager manager) {
                ++RenderingThread.CURRENT_RENDERING_INDEX;
                LittleBlockClientRegistry.clearCache();
                ITEM_RENDER_CACHE.clearCache();
            }
        });
        CreativeCoreClient.registerClientConfig((String)"littletiles");
        EntityRenderers.m_174036_((EntityType)((EntityType)LittleTilesRegistry.SIZED_TNT_TYPE.get()), RenderSizedTNTPrimed::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)LittleTilesRegistry.ENTITY_LEVEL.get()), LittleEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)LittleTilesRegistry.ENTITY_ANIMATION.get()), LittleEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)LittleTilesRegistry.SIT_TYPE.get()), LittleSitRenderer::new);
        blockEntityRenderer = new BETilesRenderer();
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)LittleTilesRegistry.BE_TILES_TYPE_RENDERED.get()), x -> blockEntityRenderer);
        ResourceLocation filled = new ResourceLocation("littletiles", "filled");
        ClampedItemPropertyFunction function = (stack, level, entity, x) -> (float)((ItemColorIngredient)stack.m_41720_()).getColor(stack) / (float)ColorIngredient.BOTTLE_SIZE;
        ItemProperties.register((Item)((Item)LittleTilesRegistry.BLACK_COLOR.get()), (ResourceLocation)filled, (ItemPropertyFunction)function);
        ItemProperties.register((Item)((Item)LittleTilesRegistry.CYAN_COLOR.get()), (ResourceLocation)filled, (ItemPropertyFunction)function);
        ItemProperties.register((Item)((Item)LittleTilesRegistry.MAGENTA_COLOR.get()), (ResourceLocation)filled, (ItemPropertyFunction)function);
        ItemProperties.register((Item)((Item)LittleTilesRegistry.YELLOW_COLOR.get()), (ResourceLocation)filled, (ItemPropertyFunction)function);
        RubidiumManager.init();
        OculusManager.init();
    }

    public static void modelLoader(ModelEvent.RegisterAdditional event) {
        event.register((ResourceLocation)new ModelResourceLocation("littletiles", "glove_background", "inventory"));
        event.register((ResourceLocation)new ModelResourceLocation("littletiles", "chisel_background", "inventory"));
        event.register((ResourceLocation)new ModelResourceLocation("littletiles", "blueprint_background", "inventory"));
    }

    public static void modelEvent(ModelEvent.RegisterGeometryLoaders event) {
        CreativeCoreClient.registerBlockModel((ResourceLocation)new ResourceLocation("littletiles", "empty"), (CreativeBlockModel)new CreativeBlockModel(){

            public List<? extends RenderBox> getBoxes(BlockState state, ModelData data, RandomSource source) {
                return Collections.EMPTY_LIST;
            }

            @NotNull
            public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
                return modelData;
            }
        });
        CreativeCoreClient.registerItemModel((ResourceLocation)new ResourceLocation("littletiles", "tiles"), (CreativeItemModel)new LittleModelItemTilesBig());
        CreativeCoreClient.registerItemModel((ResourceLocation)new ResourceLocation("littletiles", "premade"), (CreativeItemModel)new LittleModelItemTilesBig(){

            @Override
            public List<? extends RenderBox> getBoxes(ItemStack stack, boolean translucent) {
                if (!stack.m_41784_().m_128441_("s")) {
                    return Collections.EMPTY_LIST;
                }
                LittleStructurePremade.LittlePremadeType premade = ItemPremadeStructure.get(stack);
                if (premade == null) {
                    return Collections.EMPTY_LIST;
                }
                LittleGroup previews = ((ItemPremadeStructure)stack.m_41720_()).getTiles(stack);
                if (previews == null) {
                    return Collections.EMPTY_LIST;
                }
                List<RenderBox> cubes = premade.getItemPreview(previews, translucent);
                if (cubes == null) {
                    cubes = previews.getRenderingBoxes(translucent);
                    LittleGroup.shrinkCubesToOneBlock(cubes);
                }
                return cubes;
            }
        });
        CreativeCoreClient.registerItemModel((ResourceLocation)new ResourceLocation("littletiles", "glove"), (CreativeItemModel)new LittleModelItemPreview(new ModelResourceLocation("littletiles", "glove_background", "inventory"), null){

            @Override
            public boolean shouldRenderFake(ItemStack stack) {
                return true;
            }

            @Override
            protected ItemStack getFakeStack(ItemStack current) {
                GloveMode mode = ItemLittleGlove.getMode(current);
                if (mode.hasPreviewElement(current)) {
                    return new ItemStack((ItemLike)mode.getPreviewElement(current).getState().m_60734_());
                }
                if (!mode.hasTiles(current)) {
                    return ItemStack.f_41583_;
                }
                ItemStack stack = new ItemStack((ItemLike)LittleTilesRegistry.ITEM_TILES.get());
                stack.m_41751_(LittleGroup.save(mode.getTiles(current)));
                return stack;
            }
        });
        CreativeCoreClient.registerItemModel((ResourceLocation)new ResourceLocation("littletiles", "chisel"), (CreativeItemModel)new LittleModelItemPreview(new ModelResourceLocation("littletiles", "chisel_background", "inventory"), stack -> ItemLittleChisel.getElement(stack)));
        CreativeCoreClient.registerItemModel((ResourceLocation)new ResourceLocation("littletiles", "blueprint"), (CreativeItemModel)new LittleModelItemBackground(new ModelResourceLocation("littletiles", "blueprint_background", "inventory"), x -> {
            ItemStack stack = new ItemStack((ItemLike)LittleTilesRegistry.ITEM_TILES.get());
            stack.m_41751_(x.m_41784_().m_128469_("c"));
            return stack;
        }));
        CreativeCoreClient.registerItemModel((ResourceLocation)new ResourceLocation("littletiles", "blockingredient"), (CreativeItemModel)new CreativeItemBoxModel(new ModelResourceLocation("minecraft", "stone", "inventory")){

            public List<? extends RenderBox> getBoxes(ItemStack stack, boolean translucent) {
                ArrayList<RenderBox> cubes = new ArrayList<RenderBox>();
                BlockIngredientEntry ingredient = ItemBlockIngredient.loadIngredient(stack);
                if (ingredient == null) {
                    return null;
                }
                double volume = Math.min(1.0, ingredient.value);
                LittleGrid context = LittleGrid.overallDefault();
                long pixels = (long)(volume * (double)context.count3d);
                if (pixels < (long)(context.count * context.count)) {
                    cubes.add(new RenderBox(0.4f, 0.4f, 0.4f, 0.6f, 0.6f, 0.6f, ingredient.block.getState()));
                } else {
                    long remainingPixels = pixels;
                    long planes = pixels / context.count2d;
                    long rows = (remainingPixels -= planes * context.count2d) / (long)context.count;
                    remainingPixels -= rows * (long)context.count;
                    float height = (float)((double)planes * context.pixelLength);
                    if (planes > 0L) {
                        cubes.add(new RenderBox(0.0f, 0.0f, 0.0f, 1.0f, height, 1.0f, ingredient.block.getState()));
                    }
                    float width = (float)((double)rows * context.pixelLength);
                    if (rows > 0L) {
                        cubes.add(new RenderBox(0.0f, height, 0.0f, 1.0f, height + (float)context.pixelLength, width, ingredient.block.getState()));
                    }
                    if (remainingPixels > 0L) {
                        cubes.add(new RenderBox(0.0f, height, width, 1.0f, height + (float)context.pixelLength, width + (float)context.pixelLength, ingredient.block.getState()));
                    }
                }
                return cubes;
            }
        });
    }

    public static void initItemColors(RegisterColorHandlersEvent.Item event) {
        CreativeCoreClient.registerItemColor((ItemColors)event.getItemColors(), (Item)((Item)LittleTilesRegistry.PREMADE.get()));
        CreativeCoreClient.registerItemColor((ItemColors)event.getItemColors(), (Item)((Item)LittleTilesRegistry.ITEM_TILES.get()));
        event.register((stack, tint) -> {
            Item patt20332$temp = stack.m_41720_();
            if (patt20332$temp instanceof BlockItem) {
                BlockItem block = (BlockItem)patt20332$temp;
                return event.getBlockColors().m_92577_(block.m_40614_().m_49966_(), (BlockAndTintGetter)null, (BlockPos)null, tint);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)LittleTilesRegistry.WATER.get(), (ItemLike)LittleTilesRegistry.FLOWING_WATER.get()});
    }

    public static void initBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tint) -> level != null && pos != null ? ColorUtils.setAlpha((int)BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)pos), (int)255) : -12618012, new Block[]{(Block)LittleTilesRegistry.WATER.get(), (Block)LittleTilesRegistry.FLOWING_WATER.get()});
    }

    public static void commands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"lt-debug").executes(x -> {
            if (LittleTilesProfilerOverlay.isActive()) {
                LittleTilesProfilerOverlay.stop();
            } else {
                LittleTilesProfilerOverlay.start();
            }
            return 1;
        }));
    }

    public static class LittleKeyMapping
    extends KeyMapping {
        private boolean ignoreModifier = false;

        public LittleKeyMapping(String description, IKeyConflictContext keyConflictContext, int keyCode, String category) {
            super(description, keyConflictContext, KeyModifier.NONE, InputConstants.Type.KEYSYM, keyCode, category);
        }

        public LittleKeyMapping(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, int keyCode, String category) {
            super(description, keyConflictContext, keyModifier, InputConstants.Type.KEYSYM, keyCode, category);
        }

        public LittleKeyMapping ignoreModifier() {
            this.ignoreModifier = true;
            return this;
        }

        public boolean isActiveAndMatches(InputConstants.Key keyCode) {
            if (this.ignoreModifier) {
                return keyCode != InputConstants.f_84822_ && keyCode.equals((Object)this.getKey());
            }
            return super.isActiveAndMatches(keyCode);
        }

        public boolean m_90850_(KeyMapping other) {
            return other instanceof LittleKeyMapping && super.m_90850_(other);
        }
    }
}

