/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.api.common.block;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import org.joml.Vector3d;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.api.common.block.LittleBlock;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.mixin.common.level.BlockBehaviourAccessor;

public interface ILittleMCBlock
extends LittleBlock {
    public static final RandomSource RANDOM = RandomSource.m_216327_();

    public static boolean isTranslucent(Block block) {
        return !block.m_49966_().m_280296_() || !block.m_49966_().m_60815_();
    }

    public Block asVanillaBlock();

    @Override
    default public boolean isTranslucent() {
        return ILittleMCBlock.isTranslucent(this.asVanillaBlock());
    }

    @Override
    default public boolean is(ItemStack stack) {
        return Block.m_49814_((Item)stack.m_41720_()) == this.asVanillaBlock();
    }

    @Override
    default public boolean is(TagKey<Block> tag) {
        return this.asVanillaBlock().m_204297_().m_203656_(tag);
    }

    @Override
    default public ItemStack getStack() {
        return new ItemStack((ItemLike)this.asVanillaBlock());
    }

    @Override
    default public boolean canBeRenderCombined(LittleTile one, LittleTile two) {
        return one.getBlock() == two.getBlock() && one.color == two.color;
    }

    @Override
    default public boolean noCollision() {
        return !((BlockBehaviourAccessor)this.asVanillaBlock()).getHasCollision();
    }

    @Override
    default public boolean is(Block block) {
        return this.asVanillaBlock() == block;
    }

    @Override
    default public boolean canBeConvertedToVanilla() {
        return true;
    }

    @Override
    default public BlockState mirror(BlockState state, Axis axis, LittleVec doubledCenter) {
        return state;
    }

    @Override
    default public BlockState rotate(BlockState state, Rotation rotation, LittleVec doubledCenter) {
        return state;
    }

    @Override
    default public SoundType getSoundType() {
        return this.asVanillaBlock().m_49962_(this.getState());
    }

    @Override
    default public float getExplosionResistance(LittleTile tile) {
        return this.asVanillaBlock().m_7325_();
    }

    @Override
    default public void exploded(IParentCollection parent, LittleTile tile, Explosion explosion) {
    }

    @Override
    default public void randomDisplayTick(IParentCollection parent, LittleTile tile, RandomSource rand) {
    }

    @Override
    default public int getLightValue() {
        return this.getState().m_60791_();
    }

    @Override
    default public BlockState getState() {
        return this.asVanillaBlock().m_49966_();
    }

    @Override
    default public String blockName() {
        return this.asVanillaBlock().m_204297_().m_205785_().m_135782_().toString();
    }

    @Override
    default public boolean canInteract() {
        return false;
    }

    @Override
    default public InteractionResult use(IParentCollection parent, LittleTile tile, LittleBox box, Player player, BlockHitResult result, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    @Override
    default public float getEnchantPowerBonus(IParentCollection parent, LittleTile tile) {
        float bonus = this.asVanillaBlock().getEnchantPowerBonus(this.getState(), (LevelReader)parent.getLevel(), parent.getPos());
        if (bonus > 0.0f) {
            return (float)((double)bonus * tile.getPercentVolume(parent.getGrid()));
        }
        return 0.0f;
    }

    @Override
    default public float getFriction(IParentCollection parent, LittleTile tile, Entity entity) {
        return this.asVanillaBlock().getFriction(this.getState(), (LevelReader)parent.getLevel(), parent.getPos(), entity);
    }

    @Override
    default public boolean isFluid(TagKey<Fluid> fluid) {
        Block block = this.asVanillaBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock b = (LiquidBlock)block;
            return b.getFluid().m_205067_(fluid);
        }
        return false;
    }

    @Override
    default public LittleRenderBox getRenderBox(LittleGrid grid, RenderType layer, LittleBox box, LittleElement element) {
        return new LittleRenderBox(grid, box, element);
    }

    @Override
    default public boolean checkEntityCollision() {
        return false;
    }

    @Override
    default public void entityCollided(IParentCollection parent, LittleTile tile, Entity entity) {
    }

    @Override
    default public Vector3d getFogColor(IParentCollection parent, LittleTile tile, Entity entity, Vector3d originalColor, float partialTicks) {
        return originalColor;
    }

    @Override
    default public boolean shouldUseStateForRenderType() {
        return true;
    }
}

