/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.action.LittleActionActivated;
import team.creative.littletiles.common.action.LittleActionColorBoxes;
import team.creative.littletiles.common.action.LittleActionDestroy;
import team.creative.littletiles.common.action.LittleActionDestroyBoxes;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.action.LittleActionPlace;
import team.creative.littletiles.common.action.LittleActionRegistry;
import team.creative.littletiles.common.action.LittleActions;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.registry.LittleBlocks;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.config.LittleTilesConfig;
import team.creative.littletiles.common.entity.EntitySizeHandler;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;
import team.creative.littletiles.common.entity.level.LittleLevelEntity;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.ingredient.rules.IngredientRules;
import team.creative.littletiles.common.item.LittleToolHandler;
import team.creative.littletiles.common.level.handler.LittleAnimationHandlers;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.common.level.tick.LittleTickers;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.mod.theoneprobe.TheOneProbeManager;
import team.creative.littletiles.common.packet.LittlePacketTypes;
import team.creative.littletiles.common.packet.action.ActionMessagePacket;
import team.creative.littletiles.common.packet.action.BlockPacket;
import team.creative.littletiles.common.packet.action.LittleInteractionPacket;
import team.creative.littletiles.common.packet.action.PlacementPlayerSettingPacket;
import team.creative.littletiles.common.packet.action.VanillaBlockPacket;
import team.creative.littletiles.common.packet.entity.EntityOriginChanged;
import team.creative.littletiles.common.packet.entity.LittleEntityPhysicPacket;
import team.creative.littletiles.common.packet.entity.LittleEntityTransitionPacket;
import team.creative.littletiles.common.packet.entity.LittleVanillaPacket;
import team.creative.littletiles.common.packet.entity.LittleVanillaPackets;
import team.creative.littletiles.common.packet.entity.animation.LittleAnimationBlocksPacket;
import team.creative.littletiles.common.packet.entity.animation.LittleAnimationInitPacket;
import team.creative.littletiles.common.packet.entity.level.LittleLevelInitPacket;
import team.creative.littletiles.common.packet.item.MirrorPacket;
import team.creative.littletiles.common.packet.item.RotatePacket;
import team.creative.littletiles.common.packet.item.ScrewdriverSelectionPacket;
import team.creative.littletiles.common.packet.item.SelectionModePacket;
import team.creative.littletiles.common.packet.structure.BedUpdate;
import team.creative.littletiles.common.packet.structure.StructureBlockToEntityPacket;
import team.creative.littletiles.common.packet.structure.StructureEntityToBlockPacket;
import team.creative.littletiles.common.packet.structure.StructureStartAnimationPacket;
import team.creative.littletiles.common.packet.structure.StructureUpdate;
import team.creative.littletiles.common.packet.update.BlockUpdate;
import team.creative.littletiles.common.packet.update.BlocksUpdate;
import team.creative.littletiles.common.packet.update.NeighborUpdate;
import team.creative.littletiles.common.packet.update.OutputUpdate;
import team.creative.littletiles.common.placement.Placement;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.PlacementResult;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.recipe.StructureIngredient;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.registry.LittleStructureRegistry;
import team.creative.littletiles.common.structure.relative.StructureAbsolute;
import team.creative.littletiles.common.structure.type.bed.LittleBedEventHandler;
import team.creative.littletiles.mixin.server.level.ChunkMapAccessor;
import team.creative.littletiles.server.LittleTilesServer;

@Mod(value="littletiles")
public class LittleTiles {
    public static final String MODID = "littletiles";
    public static LittleTilesConfig CONFIG;
    public static final Logger LOGGER;
    public static final CreativeNetwork NETWORK;
    public static final LittleAnimationHandlers ANIMATION_HANDLERS;
    public static final LittleTickers TICKERS;
    public static TagKey<Block> STORAGE_BLOCKS;

    public LittleTiles() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> LittleTilesClient.load(FMLJavaModLoadingContext.get().getModEventBus()));
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        LittleTilesRegistry.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        LittleTilesRegistry.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        LittleTilesRegistry.BLOCK_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        LittleTilesRegistry.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        LittleTilesRegistry.CREATIVE_TABS.register(FMLJavaModLoadingContext.get().getModEventBus());
        LittleTilesRegistry.RECIPE_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        LittlePacketTypes.init();
    }

    private void init(FMLCommonSetupEvent event) {
        IngredientRules.loadRules();
        LittleStructureRegistry.initStructures();
        NETWORK.registerType(ActionMessagePacket.class, ActionMessagePacket::new);
        NETWORK.registerType(VanillaBlockPacket.class, VanillaBlockPacket::new);
        NETWORK.registerType(BlockPacket.class, BlockPacket::new);
        NETWORK.registerType(PlacementPlayerSettingPacket.class, PlacementPlayerSettingPacket::new);
        NETWORK.registerType(RotatePacket.class, RotatePacket::new);
        NETWORK.registerType(MirrorPacket.class, MirrorPacket::new);
        NETWORK.registerType(SelectionModePacket.class, SelectionModePacket::new);
        NETWORK.registerType(ScrewdriverSelectionPacket.class, ScrewdriverSelectionPacket::new);
        NETWORK.registerType(BedUpdate.class, BedUpdate::new);
        NETWORK.registerType(StructureBlockToEntityPacket.class, StructureBlockToEntityPacket::new);
        NETWORK.registerType(StructureEntityToBlockPacket.class, StructureEntityToBlockPacket::new);
        NETWORK.registerType(StructureUpdate.class, StructureUpdate::new);
        NETWORK.registerType(StructureStartAnimationPacket.class, StructureStartAnimationPacket::new);
        NETWORK.registerType(NeighborUpdate.class, NeighborUpdate::new);
        NETWORK.registerType(BlockUpdate.class, BlockUpdate::new);
        NETWORK.registerType(BlocksUpdate.class, BlocksUpdate::new);
        NETWORK.registerType(OutputUpdate.class, OutputUpdate::new);
        NETWORK.registerType(LittleEntityTransitionPacket.class, LittleEntityTransitionPacket::new);
        NETWORK.registerType(EntityOriginChanged.class, EntityOriginChanged::new);
        NETWORK.registerType(LittleEntityPhysicPacket.class, LittleEntityPhysicPacket::new);
        NETWORK.registerType(LittleAnimationInitPacket.class, LittleAnimationInitPacket::new);
        NETWORK.registerType(LittleAnimationBlocksPacket.class, LittleAnimationBlocksPacket::new);
        NETWORK.registerType(LittleVanillaPacket.class, LittleVanillaPacket::new);
        NETWORK.registerType(LittleVanillaPackets.class, LittleVanillaPackets::new);
        NETWORK.registerType(LittleLevelInitPacket.class, LittleLevelInitPacket::new);
        NETWORK.registerType(LittleInteractionPacket.class, LittleInteractionPacket::new);
        CONFIG = new LittleTilesConfig();
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG);
        LittleActionRegistry.register(LittleActions.class, LittleActions::new);
        LittleActionRegistry.register(LittleActionPlace.class, LittleActionPlace::new);
        LittleActionRegistry.register(LittleActionActivated.class, LittleActionActivated::new);
        LittleActionRegistry.register(LittleActionColorBoxes.class, LittleActionColorBoxes::new);
        LittleActionRegistry.register(LittleActionColorBoxes.LittleActionColorBoxesFiltered.class, LittleActionColorBoxes.LittleActionColorBoxesFiltered::new);
        LittleActionRegistry.register(LittleActionDestroyBoxes.class, LittleActionDestroyBoxes::new);
        LittleActionRegistry.register(LittleActionDestroyBoxes.LittleActionDestroyBoxesFiltered.class, LittleActionDestroyBoxes.LittleActionDestroyBoxesFiltered::new);
        LittleActionRegistry.register(LittleActionDestroy.class, LittleActionDestroy::new);
        MinecraftForge.EVENT_BUS.register((Object)new LittleBedEventHandler());
        MinecraftForge.EVENT_BUS.register(LittleAnimationHandlers.class);
        MinecraftForge.EVENT_BUS.register((Object)new LittleToolHandler());
        LittleTilesServer.init(event);
        if (ModList.get().isLoaded("theoneprobe")) {
            TheOneProbeManager.init();
        }
        MinecraftForge.EVENT_BUS.register(EntitySizeHandler.class);
        STORAGE_BLOCKS = BlockTags.create((ResourceLocation)new ResourceLocation(MODID, "storage_blocks"));
        CraftingHelper.register((ResourceLocation)new ResourceLocation(MODID, "structure"), (IIngredientSerializer)StructureIngredient.StructureIngredientSerializer.INSTANCE);
        LittleTilesGuiRegistry.init();
        LittleBlocks.init();
    }

    private void serverStarting(ServerStartingEvent event) {
        ForgeConfig.SERVER.fullBoundingBoxLadders.set((Object)true);
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)Commands.m_82127_((String)"lt-tovanilla").executes(x -> {
            ArrayList<BETiles> blocks = new ArrayList<BETiles>();
            for (ServerLevel level : ((CommandSourceStack)x.getSource()).m_81377_().m_129785_()) {
                for (ChunkHolder holder : ((ChunkMapAccessor)level.m_7726_().f_8325_).callGetChunks()) {
                    LevelChunk chunk = holder.m_140085_();
                    if (chunk == null) continue;
                    for (BlockEntity be : chunk.m_62954_().values()) {
                        if (!(be instanceof BETiles)) continue;
                        BETiles b = (BETiles)be;
                        blocks.add(b);
                    }
                }
            }
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237113_((String)("Attempting to convert " + blocks.size() + " blocks!")), false);
            int converted = 0;
            int i = 0;
            for (BETiles be : blocks) {
                if (be.convertBlockToVanilla()) {
                    // empty if block
                }
                int index = ++i;
                int convertedValue = ++converted;
                if (i % 50 != 0) continue;
                ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237113_((String)("Processed " + index + "/" + blocks.size() + " and converted " + convertedValue)), false);
            }
            int convertedValue = converted;
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237113_((String)("Converted " + convertedValue + " blocks")), false);
            return 0;
        }));
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)Commands.m_82127_((String)"lt-export").executes(x -> {
            LittleTilesGuiRegistry.EXPORTER.open((Player)((CommandSourceStack)x.getSource()).m_81375_());
            return 0;
        }));
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)Commands.m_82127_((String)"lt-import").executes(x -> {
            LittleTilesGuiRegistry.IMPORTER.open((Player)((CommandSourceStack)x.getSource()).m_81375_());
            return 0;
        }));
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)Commands.m_82127_((String)"level").executes(x -> {
            try {
                ServerLevel level = ((CommandSourceStack)x.getSource()).m_81372_();
                BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)x.getSource()).m_81371_()).m_7494_();
                LittleLevelEntity entity = new LittleLevelEntity((Level)level, pos);
                LittleSubLevel subLevel = entity.getSubLevel();
                LittleGrid grid = LittleGrid.overallDefault();
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("id", ((LittleStructureType)LittleStructureRegistry.REGISTRY.getDefault()).id);
                LittleGroup group = new LittleGroup(nbt, (List<LittleGroup>)Collections.EMPTY_LIST);
                group.add(grid, new LittleElement(Blocks.f_50069_.m_49966_(), -1), new LittleBox(0, grid.count - 1, 0, grid.count, grid.count, grid.count));
                subLevel.m_7731_(pos.m_7494_(), Blocks.f_50493_.m_49966_(), 3);
                PlacementPreview preview = PlacementPreview.load(null, PlacementMode.ALL, new LittleGroupAbsolute(pos, group), Facing.EAST);
                Placement placement = new Placement(null, (Level)subLevel, preview);
                PlacementResult result = placement.place();
                if (result == null) {
                    throw new LittleActionException("Could not be placed");
                }
                level.m_7967_((Entity)entity);
                ((CommandSourceStack)x.getSource()).m_243053_((Component)Component.m_237113_((String)"Spawned level"));
            }
            catch (LittleActionException e) {
                ((CommandSourceStack)x.getSource()).m_81352_(e.getTranslatable());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            catch (Error e) {
                e.printStackTrace();
            }
            return 0;
        }));
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)Commands.m_82127_((String)"animation").executes(x -> {
            try {
                ServerLevel level = ((CommandSourceStack)x.getSource()).m_81372_();
                BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)x.getSource()).m_81371_()).m_7494_();
                LittleAnimationLevel subLevel = new LittleAnimationLevel((Level)level);
                LittleGrid grid = LittleGrid.overallDefault();
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("id", ((LittleStructureType)LittleStructureRegistry.REGISTRY.getDefault()).id);
                LittleGroup group = new LittleGroup(nbt, (List<LittleGroup>)Collections.EMPTY_LIST);
                group.add(grid, new LittleElement(Blocks.f_50069_.m_49966_(), -1), new LittleBox(0, grid.count - 1, 0, grid.count, grid.count, grid.count));
                PlacementPreview preview = PlacementPreview.load(null, PlacementMode.ALL, new LittleGroupAbsolute(pos, group), Facing.EAST);
                level.m_7967_((Entity)new LittleAnimationEntity((Level)level, subLevel, new StructureAbsolute(pos, grid.box(), grid), new Placement(null, subLevel, preview)));
                ((CommandSourceStack)x.getSource()).m_243053_((Component)Component.m_237113_((String)"Spawned animation"));
            }
            catch (LittleActionException e) {
                ((CommandSourceStack)x.getSource()).m_81352_(e.getTranslatable());
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                throw e;
            }
            return 0;
        }));
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)Commands.m_82127_((String)"lt-optimize").executes(x -> {
            int levels = 0;
            int chunks = 0;
            int totalTiles = 0;
            int newCount = 0;
            int toVanilla = 0;
            ArrayList<BETiles> blocks = new ArrayList<BETiles>();
            for (Object level : ((CommandSourceStack)x.getSource()).m_81377_().m_129785_()) {
                for (ChunkHolder holder : ((ChunkMapAccessor)level.m_7726_().f_8325_).callGetChunks()) {
                    LevelChunk chunk = holder.m_140085_();
                    if (chunk != null) {
                        for (BlockEntity be : chunk.m_62954_().values()) {
                            if (!(be instanceof BETiles)) continue;
                            BETiles b = (BETiles)be;
                            blocks.add(b);
                        }
                    }
                    ++chunks;
                }
                ++levels;
            }
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237113_((String)("Attempting to optimize " + blocks.size() + " blocks!")), false);
            int i = 0;
            for (BETiles be : blocks) {
                totalTiles += be.boxesCount();
                be.optimizeTiles();
                if (be.convertBlockToVanilla()) {
                    ++toVanilla;
                } else {
                    newCount += be.boxesCount();
                }
                int index = ++i;
                if (i % 50 != 0) continue;
                ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237113_((String)("Processed " + index + "/" + blocks.size() + " blocks")), false);
            }
            if (toVanilla > 0) {
                int convertedBlocks = toVanilla;
                ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237113_((String)("Converted " + convertedBlocks + " to vanilla blocks.")), false);
            }
            int result = totalTiles - newCount;
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237113_((String)("Optimization could save " + result + " tiles.")), false);
            int levelCount = levels;
            int chunkCount = chunks;
            int tilesCount = totalTiles;
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237113_((String)("Scanned " + levelCount + " levels, " + chunkCount + " chunks, " + blocks.size() + " blocks, " + tilesCount + " tiles")), false);
            return 0;
        }));
    }

    protected boolean checkStructureName(LittleStructure structure, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (structure.name == null || !structure.name.equalsIgnoreCase(args[i])) continue;
            return true;
        }
        return false;
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        NETWORK = new CreativeNetwork(1, LOGGER, new ResourceLocation(MODID, "main"));
        ANIMATION_HANDLERS = new LittleAnimationHandlers();
        TICKERS = new LittleTickers();
    }
}

