/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.data;

import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.littleframes.LittleFrames;

public class LittleFrameData {
    private URI uri;
    public float brightness = 1.0f;
    public float alpha = 1.0f;
    public int renderDistance = 64;
    private float volume = 1.0f;
    public float minDistance = 5.0f;
    public float maxDistance = 20.0f;
    public boolean loop = true;
    public int tick = 0;
    public int refreshInterval = -1;
    public int refreshCounter = 0;

    public static LittleFrameData ofOldData(CompoundTag nbt) {
        LittleFrameData data = new LittleFrameData();
        try {
            data.uri = new URI(nbt.m_128461_("url"));
        }
        catch (URISyntaxException e) {
            LittleFrames.LOGGER.error("Tried to load invalid url '{}'", (Object)nbt.m_128461_("url"));
            data.uri = null;
        }
        if (nbt.m_128441_("render")) {
            data.renderDistance = nbt.m_128451_("render");
        }
        if (nbt.m_128441_("alpha")) {
            data.alpha = nbt.m_128457_("alpha");
        }
        if (nbt.m_128441_("brightness")) {
            data.brightness = nbt.m_128457_("brightness");
        }
        data.volume = nbt.m_128457_("volume");
        if (nbt.m_128441_("min")) {
            data.minDistance = nbt.m_128457_("min");
        }
        if (nbt.m_128441_("max")) {
            data.maxDistance = nbt.m_128457_("max");
        }
        data.tick = nbt.m_128451_("tick");
        data.loop = nbt.m_128471_("loop");
        int n = data.refreshInterval = nbt.m_128441_("refresh") ? nbt.m_128451_("refresh") : -1;
        if (data.refreshInterval > 0) {
            data.refreshCounter = data.refreshInterval;
        }
        return data;
    }

    public LittleFrameData() {
    }

    public LittleFrameData(CompoundTag nbt) {
        try {
            this.uri = nbt.m_128441_("u") ? new URI(nbt.m_128461_("u")) : null;
        }
        catch (URISyntaxException e) {
            LittleFrames.LOGGER.error("Tried to load invalid url '{}'", (Object)nbt.m_128461_("u"));
            this.uri = null;
        }
        if (nbt.m_128441_("d")) {
            this.renderDistance = nbt.m_128451_("d");
        }
        if (nbt.m_128441_("a")) {
            this.alpha = nbt.m_128457_("a");
        }
        if (nbt.m_128441_("b")) {
            this.brightness = nbt.m_128457_("b");
        }
        this.volume = nbt.m_128457_("v");
        if (nbt.m_128441_("min")) {
            this.minDistance = nbt.m_128457_("min");
        }
        if (nbt.m_128441_("max")) {
            this.maxDistance = nbt.m_128457_("max");
        }
        this.tick = nbt.m_128451_("t");
        this.loop = nbt.m_128471_("l");
        int n = this.refreshInterval = nbt.m_128441_("r") ? nbt.m_128451_("r") : -1;
        if (this.refreshInterval > 0) {
            this.refreshCounter = this.refreshInterval;
        }
    }

    public boolean hasURI() {
        return this.uri != null;
    }

    public void setURI(URI uri) {
        this.uri = uri.toString().isBlank() ? null : uri;
    }

    public void stop() {
        this.tick = 0;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getURIPath() {
        return this.uri != null ? this.uri.toString() : "";
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        if (this.uri != null) {
            nbt.m_128359_("u", this.uri.toString());
        }
        nbt.m_128405_("d", this.renderDistance);
        nbt.m_128350_("a", this.alpha);
        nbt.m_128350_("b", this.brightness);
        nbt.m_128350_("v", this.volume);
        nbt.m_128350_("min", this.minDistance);
        nbt.m_128350_("max", this.maxDistance);
        nbt.m_128405_("t", this.tick);
        nbt.m_128379_("l", this.loop);
        if (this.refreshInterval < 0) {
            nbt.m_128473_("r");
        } else {
            nbt.m_128405_("r", this.refreshInterval);
        }
        return nbt;
    }

    public void volume(float volume) {
        this.volume = volume;
    }

    public float volume() {
        return this.volume;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float ingameVolume() {
        return this.volume * Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER);
    }
}

