/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.block;

import java.net.URI;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.watermedia.api.image.ImageAPI;
import org.watermedia.api.image.ImageCache;
import team.creative.creativecore.common.be.BlockEntityCreative;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.vec.Vec2f;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.LittleFramesRegistry;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.display.FramePictureDisplay;
import team.creative.littleframes.client.display.FrameVideoDisplay;
import team.creative.littleframes.common.block.BlockCreativePictureFrame;
import team.creative.littleframes.common.data.LittleFrameData;
import team.creative.littleframes.common.packet.CreativePictureFramePacket;

public class BECreativePictureFrame
extends BlockEntityCreative {
    public Vec2f min = new Vec2f(0.0f, 0.0f);
    public Vec2f max = new Vec2f(1.0f, 1.0f);
    public float rotation = 0.0f;
    public boolean flipX = false;
    public boolean flipY = false;
    public boolean visibleFrame = true;
    public boolean bothSides = false;
    public boolean playing = true;
    public LittleFrameData data = new LittleFrameData();
    private boolean released = false;
    @OnlyIn(value=Dist.CLIENT)
    public ImageCache cache;
    @OnlyIn(value=Dist.CLIENT)
    public FrameDisplay display;

    public BECreativePictureFrame(BlockPos pos, BlockState state) {
        super((BlockEntityType)LittleFramesRegistry.BE_CREATIVE_FRAME.get(), pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isURLEmpty() {
        return !this.data.hasURI();
    }

    public void setURL(URI url) {
        this.data.setURI(url);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FrameDisplay requestDisplay() {
        if (!this.data.hasURI() && this.display != null) {
            this.cleanDisplay();
            return null;
        }
        if (this.released) {
            this.cache = null;
            return null;
        }
        if (this.cache == null && !this.data.hasURI()) {
            this.cleanDisplay();
            return null;
        }
        if (this.cache == null || this.data.hasURI() && !this.cache.uri.equals(this.data.getURI())) {
            this.cache = ImageAPI.getCache((URI)this.data.getURI(), (Executor)Minecraft.m_91087_());
            this.cleanDisplay();
        }
        switch (this.cache.getStatus()) {
            case READY: {
                if (this.display != null) {
                    return this.display;
                }
                if (this.cache.isVideo()) {
                    this.display = FrameVideoDisplay.createVideoDisplay(new Vec3d((Vec3i)this.f_58858_), this.data);
                    return this.display;
                }
                this.display = new FramePictureDisplay(this.cache);
                return this.display;
            }
            case WAITING: {
                this.cleanDisplay();
                this.cache.load();
                return this.display;
            }
            case LOADING: 
            case FAILED: {
                return null;
            }
            case FORGOTTEN: {
                LittleFrames.LOGGER.warn("Cached picture is forgotten, cleaning and reloading");
                this.cache = null;
                return null;
            }
        }
        LittleFrames.LOGGER.warn("WATERMeDIA Behavior is modified, this shouldn't be executed");
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void cleanDisplay() {
        if (this.display != null) {
            this.display.release();
            this.display = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void release() {
        this.cleanDisplay();
        this.released = true;
    }

    public AlignedBox getBox() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BlockCreativePictureFrame.FACING);
        Facing facing = Facing.get((Direction)direction);
        AlignedBox box = BlockCreativePictureFrame.box(direction);
        Axis one = facing.one();
        Axis two = facing.two();
        if (facing.axis != Axis.Z) {
            one = facing.two();
            two = facing.one();
        }
        box.setMin(one, this.min.x);
        box.setMax(one, this.max.x);
        box.setMin(two, this.min.y);
        box.setMax(two, this.max.y);
        return box;
    }

    public float getSizeX() {
        return this.max.x - this.min.x;
    }

    public float getSizeY() {
        return this.max.y - this.min.y;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return this.getBox().getBB(this.m_58899_());
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.savePicture(nbt);
    }

    public void play() {
        this.playing = true;
        LittleFrames.NETWORK.sendToClient((CreativePacket)new CreativePictureFramePacket(this.f_58858_, this.playing, this.data.tick), this.f_58857_, this.f_58858_);
    }

    public void pause() {
        this.playing = false;
        LittleFrames.NETWORK.sendToClient((CreativePacket)new CreativePictureFramePacket(this.f_58858_, this.playing, this.data.tick), this.f_58857_, this.f_58858_);
    }

    public void stop() {
        this.playing = false;
        this.data.stop();
        LittleFrames.NETWORK.sendToClient((CreativePacket)new CreativePictureFramePacket(this.f_58858_, this.playing, this.data.tick), this.f_58857_, this.f_58858_);
    }

    protected void savePicture(CompoundTag nbt) {
        nbt.m_128350_("minx", this.min.x);
        nbt.m_128350_("miny", this.min.y);
        nbt.m_128350_("maxx", this.max.x);
        nbt.m_128350_("maxy", this.max.y);
        nbt.m_128350_("rotation", this.rotation);
        nbt.m_128379_("visibleFrame", this.visibleFrame);
        nbt.m_128379_("bothSides", this.bothSides);
        nbt.m_128379_("flipX", this.flipX);
        nbt.m_128379_("flipY", this.flipY);
        nbt.m_128379_("playing", this.playing);
        nbt.m_128365_("data", (Tag)this.data.save());
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.loadPicture(nbt);
    }

    protected void loadPicture(CompoundTag nbt) {
        this.min.x = nbt.m_128457_("minx");
        this.min.y = nbt.m_128457_("miny");
        this.max.x = nbt.m_128457_("maxx");
        this.max.y = nbt.m_128457_("maxy");
        this.rotation = nbt.m_128457_("rotation");
        this.visibleFrame = nbt.m_128471_("visibleFrame");
        this.bothSides = nbt.m_128471_("bothSides");
        this.flipX = nbt.m_128471_("flipX");
        this.flipY = nbt.m_128471_("flipY");
        this.playing = nbt.m_128471_("playing");
        this.data = nbt.m_128441_("data") ? new LittleFrameData(nbt.m_128469_("data")) : (nbt.m_128441_("url") ? LittleFrameData.ofOldData(nbt) : new LittleFrameData());
    }

    public void handleUpdate(CompoundTag nbt, boolean chunkUpdate) {
        this.loadPicture(nbt);
        this.markDirty();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof BECreativePictureFrame) {
            BECreativePictureFrame be = (BECreativePictureFrame)blockEntity;
            if (level.f_46443_) {
                FrameDisplay display = be.requestDisplay();
                if (display != null && display.canTick()) {
                    display.tick(be.data, be.playing);
                }
                if (be.data.refreshInterval > 0) {
                    if (be.data.refreshCounter <= 0) {
                        be.data.refreshCounter = be.data.refreshInterval;
                        if (be.cache != null) {
                            be.cache.reload();
                        }
                    } else {
                        --be.data.refreshCounter;
                    }
                }
            }
            if (be.playing) {
                ++be.data.tick;
            }
        }
    }

    public void m_7651_() {
        if (this.isClient() && this.display != null) {
            this.release();
        }
        super.m_7651_();
    }

    public void onChunkUnloaded() {
        if (this.isClient() && this.display != null) {
            this.release();
        }
        super.onChunkUnloaded();
    }
}

