/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.gui;

import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.watermedia.api.image.ImageAPI;
import org.watermedia.api.image.ImageCache;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.parent.GuiColumn;
import team.creative.creativecore.common.gui.controls.parent.GuiRow;
import team.creative.creativecore.common.gui.controls.parent.GuiTable;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiButtonIcon;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.controls.simple.GuiCounterDecimal;
import team.creative.creativecore.common.gui.controls.simple.GuiDuration;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiSlider;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.text.ITextCollection;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextListBuilder;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.gui.GuiUrlTextfield;
import team.creative.littleframes.common.block.BECreativePictureFrame;

public class GuiCreativePictureFrame
extends GuiLayer {
    public BECreativePictureFrame frame;
    public float scaleMultiplier;
    public GuiTextfield url;
    public final GuiSyncLocal<EndTag> PLAY = this.getSyncHolder().register("play", x -> this.frame.play());
    public final GuiSyncLocal<EndTag> PAUSE = this.getSyncHolder().register("pause", x -> this.frame.pause());
    public final GuiSyncLocal<EndTag> STOP = this.getSyncHolder().register("stop", x -> this.frame.stop());
    public final GuiSyncLocal<CompoundTag> SET_DATA = this.getSyncHolder().register("set_data", nbt -> {
        String url = nbt.m_128461_("url");
        if (LittleFrames.CONFIG.canUse(this.getPlayer(), url)) {
            float middle;
            try {
                this.frame.setURL(new URI(url));
            }
            catch (URISyntaxException e) {
                LittleFrames.LOGGER.error("Failed to save url '{}'", (Object)url);
            }
            float sizeX = (float)Math.min(LittleFrames.CONFIG.sizeLimitation, (double)nbt.m_128457_("x"));
            float sizeY = (float)Math.min(LittleFrames.CONFIG.sizeLimitation, (double)nbt.m_128457_("y"));
            byte posX = nbt.m_128445_("posX");
            byte posY = nbt.m_128445_("posY");
            if (posX == 0) {
                this.frame.min.x = 0.0f;
                this.frame.max.x = sizeX;
            } else if (posX == 1) {
                middle = sizeX / 2.0f;
                this.frame.min.x = 0.5f - middle;
                this.frame.max.x = 0.5f + middle;
            } else {
                this.frame.min.x = 1.0f - sizeX;
                this.frame.max.x = 1.0f;
            }
            if (posY == 0) {
                this.frame.min.y = 0.0f;
                this.frame.max.y = sizeY;
            } else if (posY == 1) {
                middle = sizeY / 2.0f;
                this.frame.min.y = 0.5f - middle;
                this.frame.max.y = 0.5f + middle;
            } else {
                this.frame.min.y = 1.0f - sizeY;
                this.frame.max.y = 1.0f;
            }
            this.frame.data.renderDistance = Math.min(LittleFrames.CONFIG.maxRenderDistance, nbt.m_128451_("render"));
            this.frame.rotation = nbt.m_128457_("rotation");
            this.frame.visibleFrame = nbt.m_128471_("visibleFrame");
            this.frame.bothSides = nbt.m_128471_("bothSides");
            this.frame.data.loop = nbt.m_128471_("loop");
            this.frame.flipX = nbt.m_128471_("flipX");
            this.frame.flipY = nbt.m_128471_("flipY");
            this.frame.data.volume(nbt.m_128457_("volume"));
            this.frame.data.minDistance = nbt.m_128457_("min");
            this.frame.data.maxDistance = nbt.m_128457_("max");
            this.frame.data.alpha = nbt.m_128457_("transparency");
            this.frame.data.brightness = nbt.m_128457_("brightness");
            this.frame.data.refreshCounter = this.frame.data.refreshInterval = nbt.m_128451_("refresh");
        }
        this.frame.markDirty();
    });

    public GuiCreativePictureFrame(BECreativePictureFrame frame) {
        this(frame, 16);
    }

    public GuiCreativePictureFrame(BECreativePictureFrame frame, int scaleSize) {
        super("creative_frame", 200, 210);
        this.frame = frame;
        this.scaleMultiplier = 1.0f / (float)scaleSize;
    }

    public void create() {
        GuiButton save = new GuiButton("save", x -> {
            CompoundTag nbt = new CompoundTag();
            GuiTextfield url = (GuiTextfield)this.get("url");
            GuiCounterDecimal sizeX = (GuiCounterDecimal)this.get("sizeX");
            GuiCounterDecimal sizeY = (GuiCounterDecimal)this.get("sizeY");
            GuiStateButton buttonPosX = (GuiStateButton)this.get("posX");
            GuiStateButton buttonPosY = (GuiStateButton)this.get("posY");
            GuiSlider rotation = (GuiSlider)this.get("rotation");
            GuiCheckBox flipX = (GuiCheckBox)this.get("flipX");
            GuiCheckBox flipY = (GuiCheckBox)this.get("flipY");
            GuiCheckBox visibleFrame = (GuiCheckBox)this.get("visibleFrame");
            GuiCheckBox bothSides = (GuiCheckBox)this.get("bothSides");
            GuiSteppedSlider renderDistance = (GuiSteppedSlider)this.get("distance");
            GuiSlider transparency = (GuiSlider)this.get("transparency");
            GuiSlider brightness = (GuiSlider)this.get("brightness");
            GuiCheckBox loop = (GuiCheckBox)this.get("loop");
            GuiSlider volume = (GuiSlider)this.get("volume");
            GuiSteppedSlider min = (GuiSteppedSlider)this.get("range_min");
            GuiSteppedSlider max = (GuiSteppedSlider)this.get("range_max");
            GuiCheckBox autoRefresh = (GuiCheckBox)this.get("autoRefresh");
            GuiDuration duration = (GuiDuration)this.get("duration");
            nbt.m_128344_("posX", (byte)buttonPosX.getState());
            nbt.m_128344_("posY", (byte)buttonPosY.getState());
            nbt.m_128350_("rotation", (float)rotation.getValue());
            nbt.m_128379_("flipX", flipX.value);
            nbt.m_128379_("flipY", flipY.value);
            nbt.m_128379_("visibleFrame", visibleFrame.value);
            nbt.m_128379_("bothSides", bothSides.value);
            nbt.m_128405_("render", (int)renderDistance.getValue());
            nbt.m_128350_("transparency", (float)transparency.getValue());
            nbt.m_128350_("brightness", (float)brightness.getValue());
            nbt.m_128379_("loop", loop.value);
            nbt.m_128350_("volume", (float)volume.getValue());
            nbt.m_128350_("min", (float)min.getIntValue());
            nbt.m_128350_("max", (float)max.getIntValue());
            nbt.m_128359_("url", url.getText());
            nbt.m_128350_("x", Math.max(0.1f, (float)sizeX.getValue()));
            nbt.m_128350_("y", Math.max(0.1f, (float)sizeY.getValue()));
            nbt.m_128405_("refresh", autoRefresh.value ? duration.getDuration() : -1);
            this.SET_DATA.send((Tag)nbt);
        });
        save.setTranslate("gui.save");
        this.align = Align.STRETCH;
        this.flow = GuiFlow.STACK_Y;
        this.url = new GuiUrlTextfield(save, "url", this.frame.data.getURIPath());
        this.add((GuiControl)this.url);
        GuiLabel error = new GuiLabel("error").setDefaultColor(-65536);
        if (this.frame.isClient() && this.frame.cache != null && this.frame.cache.getStatus().equals((Object)ImageCache.Status.FAILED)) {
            Exception e = this.frame.cache.getException();
            if (this.frame.cache.isVideo()) {
                if (!LittleFrames.CONFIG.useVLC) {
                    error.setTitle((Component)Component.m_237113_((String)"Image not found"));
                }
            } else if (e.getMessage() == null) {
                error.setTranslate("download.exception.invalid");
            } else if (e.getMessage().startsWith("Server returned HTTP response code: 403")) {
                error.setTranslate("download.exception.forbidden");
            } else if (e.getMessage().startsWith("Server returned HTTP response code: 404")) {
                error.setTranslate("download.exception.notfound");
            } else {
                error.setTranslate("download.exception.invalid");
            }
        }
        this.add((GuiControl)error);
        GuiParent size = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        size.align = Align.STRETCH;
        this.add((GuiControl)size);
        size.add((GuiControl)new GuiCounterDecimal("sizeX", this.frame.getSizeX(), 0.0, 3.4028234663852886E38){

            public void stepUp() {
                int scaled = (int)(this.getValue() / (double)GuiCreativePictureFrame.this.scaleMultiplier);
                this.setValue(Math.min(this.max, (double)((float)(++scaled) * GuiCreativePictureFrame.this.scaleMultiplier)));
            }

            public void stepDown() {
                int scaled = (int)(this.getValue() / (double)GuiCreativePictureFrame.this.scaleMultiplier);
                this.setValue(Math.max(this.max, (double)((float)(--scaled) * GuiCreativePictureFrame.this.scaleMultiplier)));
            }
        });
        size.add((GuiControl)new GuiButton("reX", but -> {
            GuiCounterDecimal sizeXField = (GuiCounterDecimal)this.get("sizeX", GuiCounterDecimal.class);
            GuiCounterDecimal sizeYField = (GuiCounterDecimal)this.get("sizeY", GuiCounterDecimal.class);
            double x = sizeXField.getValue();
            if (this.frame.display != null) {
                sizeYField.setValue((double)this.frame.display.getHeight() / ((double)this.frame.display.getWidth() / x));
            }
        }).setTitle((Component)Component.m_237113_((String)"x->y")));
        size.add((GuiControl)new GuiCounterDecimal("sizeY", this.frame.getSizeY(), 0.0, 3.4028234663852886E38){

            public void stepUp() {
                int scaled = (int)(this.getValue() / (double)GuiCreativePictureFrame.this.scaleMultiplier);
                this.setValue(Math.min(this.max, (double)((float)(++scaled) * GuiCreativePictureFrame.this.scaleMultiplier)));
            }

            public void stepDown() {
                int scaled = (int)(this.getValue() / (double)GuiCreativePictureFrame.this.scaleMultiplier);
                this.setValue(Math.max(this.max, (double)((float)(--scaled) * GuiCreativePictureFrame.this.scaleMultiplier)));
            }
        });
        size.add((GuiControl)new GuiButton("reY", but -> {
            GuiCounterDecimal sizeXField = (GuiCounterDecimal)this.get("sizeX", GuiCounterDecimal.class);
            GuiCounterDecimal sizeYField = (GuiCounterDecimal)this.get("sizeY", GuiCounterDecimal.class);
            double y = sizeYField.getValue();
            if (this.frame.display != null) {
                sizeXField.setValue((double)this.frame.display.getWidth() / ((double)this.frame.display.getHeight() / y));
            }
        }).setTitle((Component)Component.m_237113_((String)"y->x")));
        GuiParent flip = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)flip);
        flip.add((GuiControl)new GuiCheckBox("flipX", this.frame.flipX).setTranslate("gui.creative_frame.flipx"));
        flip.add((GuiControl)new GuiCheckBox("flipY", this.frame.flipY).setTranslate("gui.creative_frame.flipy"));
        GuiParent align = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)align);
        align.add((GuiControl)new GuiStateButton("posX", this.frame.min.x == 0.0f ? 0 : (this.frame.max.x == 1.0f ? 2 : 1), (ITextCollection)new TextListBuilder().addTranslated("gui.creative_frame.posx.", new String[]{"left", "center", "right"})));
        align.add((GuiControl)new GuiStateButton("posY", this.frame.min.y == 0.0f ? 0 : (this.frame.max.y == 1.0f ? 2 : 1), (ITextCollection)new TextListBuilder().addTranslated("gui.creative_frame.posy.", new String[]{"top", "center", "bottom"})));
        GuiTable table = new GuiTable();
        this.add((GuiControl)table);
        GuiColumn left = new GuiColumn();
        GuiColumn right = new GuiColumn();
        table.addRow(new GuiRow(new GuiColumn[]{left, right}));
        left.add((GuiControl)new GuiLabel("t_label").setTitle((Component)Component.m_237115_((String)"gui.creative_frame.rotation").m_130946_(":")));
        right.add(new GuiSlider("rotation", (double)this.frame.rotation, 0.0, 360.0).setExpandableX());
        left = new GuiColumn();
        right = new GuiColumn();
        table.addRow(new GuiRow(new GuiColumn[]{left, right}));
        left.add((GuiControl)new GuiLabel("t_label").setTitle((Component)Component.m_237115_((String)"gui.creative_frame.transparency").m_130946_(":")));
        right.add(new GuiSlider("transparency", (double)this.frame.data.alpha, 0.0, 1.0).setExpandableX());
        left = new GuiColumn();
        right = new GuiColumn();
        table.addRow(new GuiRow(new GuiColumn[]{left, right}));
        left.add((GuiControl)new GuiLabel("b_label").setTitle((Component)Component.m_237115_((String)"gui.creative_frame.brightness").m_130946_(":")));
        right.add(new GuiSlider("brightness", (double)this.frame.data.brightness, 0.0, 1.0).setExpandableX());
        left = new GuiColumn();
        right = new GuiColumn();
        table.addRow(new GuiRow(new GuiColumn[]{left, right}));
        left.add((GuiControl)new GuiLabel("d_label").setTitle((Component)Component.m_237115_((String)"gui.creative_frame.distance").m_130946_(":")));
        right.add(new GuiSteppedSlider("distance", this.frame.data.renderDistance, 5, 1024).setExpandableX());
        GuiParent rendering = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)rendering);
        rendering.add((GuiControl)new GuiCheckBox("visibleFrame", this.frame.visibleFrame).setTranslate("gui.creative_frame.visibleFrame"));
        rendering.add((GuiControl)new GuiCheckBox("bothSides", this.frame.bothSides).setTranslate("gui.creative_frame.bothSides"));
        GuiParent play = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)play);
        play.add((GuiControl)new GuiButtonIcon("play", Icon.PLAY, button -> this.PLAY.send((Tag)EndTag.f_128534_)));
        play.add((GuiControl)new GuiButtonIcon("pause", Icon.PAUSE, button -> this.PAUSE.send((Tag)EndTag.f_128534_)));
        play.add((GuiControl)new GuiButtonIcon("stop", Icon.STOP, button -> this.STOP.send((Tag)EndTag.f_128534_)));
        play.add((GuiControl)new GuiCheckBox("loop", this.frame.data.loop).setTranslate("gui.creative_frame.loop"));
        play.add((GuiControl)new GuiLabel("v_label").setTranslate("gui.creative_frame.volume"));
        play.add((GuiControl)new GuiSlider("volume", (double)this.frame.data.volume(), 0.0, 1.0));
        GuiParent range = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)range);
        range.add((GuiControl)new GuiLabel("range_label").setTranslate("gui.creative_frame.range"));
        range.add(new GuiSteppedSlider("range_min", (int)this.frame.data.minDistance, 0, 512).setExpandableX());
        range.add(new GuiSteppedSlider("range_max", (int)this.frame.data.maxDistance, 0, 512).setExpandableX());
        GuiParent refresh = new GuiParent();
        refresh.spacing = 10;
        this.add((GuiControl)refresh.setVAlign(VAlign.CENTER));
        refresh.add((GuiControl)new GuiCheckBox("autoRefresh", this.frame.data.refreshInterval > 0).setTranslate("gui.creative_frame.autoReload"));
        refresh.add((GuiControl)new GuiDuration("duration", this.frame.data.refreshInterval, false, true, true, true));
        GuiParent bottom = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        bottom.align = Align.RIGHT;
        this.add((GuiControl)bottom);
        save.setEnabled(LittleFrames.CONFIG.canUse(this.getPlayer(), this.url.getText()));
        bottom.add((GuiControl)save);
        bottom.add(new GuiButton("reload", x -> {
            if (Screen.m_96638_()) {
                ImageAPI.reloadCache();
            } else if (this.frame.cache != null) {
                this.frame.cache.reload();
            }
        }).setTranslate("gui.creative_frame.reload").setTooltip(new TextBuilder().translate("gui.creative_frame.reloadtooltip").build()));
    }
}

