/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.util.mc.PlayerUtils;

public class LittleFramesConfig {
    @CreativeConfig
    public double sizeLimitation = 1000.0;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public int maxRenderDistance = 10000;
    @CreativeConfig
    public boolean onlyOps = false;
    @CreativeConfig
    public boolean disableAdventure = true;
    @CreativeConfig
    public boolean onlyCreative = false;
    @CreativeConfig
    public boolean whitelistEnabled = false;
    @CreativeConfig(type=ConfigSynchronization.CLIENT)
    public boolean useVLC = true;
    @CreativeConfig
    public List<String> whitelist = Arrays.asList("imgur.com", "gyazo.com", "prntscr.com", "tinypic.com", "puu.sh", "pinimg.com", "photobucket.com", "staticflickr.com", "flic.kr", "tenor.co", "gfycat.com", "giphy.com", "gph.is", "gifbin.com", "i.redd.it", "media.tumblr.com", "twimg.com", "discordapp.com", "images.discordapp.net", "githubusercontent.com", "googleusercontent.com", "googleapis.com", "wikimedia.org", "ytimg.com");

    public boolean canUse(Player player, String url) {
        return this.canUse(player, url, false);
    }

    public boolean canUse(Player player, String url, boolean ignoreToggle) {
        Level level = player.m_9236_();
        if (!level.f_46443_ && (level.m_7654_().m_129792_() || player.m_20310_(level.m_7654_().m_7022_()))) {
            return true;
        }
        if (this.whitelistEnabled || ignoreToggle) {
            try {
                return this.isDomainWhitelisted(new URI(url.toLowerCase(Locale.ROOT)).getHost());
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return true;
    }

    public boolean isDomainWhitelisted(String domain) {
        if (domain != null) {
            for (String url : this.whitelist) {
                String formattedUrl = url.trim().toLowerCase(Locale.ROOT);
                if (!domain.endsWith("." + formattedUrl) && !domain.equals(formattedUrl)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canInteract(Player player, Level level) {
        boolean isOperator;
        if (this.disableAdventure && PlayerUtils.getGameType((Player)player) == GameType.ADVENTURE) {
            return false;
        }
        if (this.onlyCreative && !player.m_7500_()) {
            return false;
        }
        boolean bl = isOperator = level.m_7654_().m_129792_() || player.m_20310_(level.m_7654_().m_7022_());
        if (this.onlyOps) {
            return isOperator;
        }
        return isOperator || !this.disableAdventure || player.m_150110_().f_35938_;
    }
}

