/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.moddingx.libx.datagen.PackTarget;

public class PathResource
implements PackTarget.Resource {
    private final Path path;
    private ResourceMetadata metadata;

    public PathResource(Path path) {
        this.path = path;
        this.metadata = null;
    }

    @Override
    public InputStream open() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public BufferedReader read() throws IOException {
        return Files.newBufferedReader(this.path, StandardCharsets.UTF_8);
    }

    @Override
    public ResourceMetadata meta() throws IOException {
        if (this.metadata == null) {
            Path metaPath = this.path.resolveSibling(this.path.getFileName() + ".mcmeta");
            if (!Files.isRegularFile(metaPath, new LinkOption[0])) {
                return ResourceMetadata.f_215577_;
            }
            try (InputStream in = Files.newInputStream(metaPath, new OpenOption[0]);){
                this.metadata = ResourceMetadata.m_215580_((InputStream)in);
            }
        }
        return this.metadata;
    }
}

