/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.annotation.processor.modinit.register;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.tools.Diagnostic;
import org.moddingx.libx.annotation.processor.modinit.FailureException;
import org.moddingx.libx.annotation.processor.modinit.ModEnv;
import org.moddingx.libx.annotation.processor.modinit.ModInit;
import org.moddingx.libx.annotation.processor.modinit.register.RegistrationEntry;
import org.moddingx.libx.annotation.registration.PlainRegisterable;
import org.moddingx.libx.annotation.registration.Reg;
import org.moddingx.libx.annotation.registration.RegisterClass;

public class RegisterClassProcessor {
    public static void processRegisterClass(Element element, ModEnv env) {
        if (element.getKind() != ElementKind.CLASS || !element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Element annotated with @RegisterClass is not a public class.", element);
            return;
        }
        if (element.getEnclosingElement().getKind() != ElementKind.PACKAGE || !(element.getEnclosingElement() instanceof PackageElement)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Parent of element annotated with @RegisterClass is not a package", element);
            return;
        }
        RegisterClass registerClass = element.getAnnotation(RegisterClass.class);
        ModInit mod = env.getMod(element);
        if (!env.subTypeErasure(mod.modClass.asType(), env.forClass("org.moddingx.libx.mod.ModXRegistration"))) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "@RegisterClass used with a mod that is not a subtype of ModXRegistration", element);
            return;
        }
        TargetRegistry target = RegisterClassProcessor.resolveRegistry(element, registerClass, env);
        List<RegistrationEntry> entries = element.getEnclosedElements().stream().flatMap(e -> RegisterClassProcessor.fromElement(registerClass, e, target, env)).collect(Collectors.toList());
        mod.addRegistration(registerClass.priority(), entries);
    }

    private static TargetRegistry resolveRegistry(Element classElem, RegisterClass classAnnotation, ModEnv env) {
        if (classAnnotation.registry().isEmpty()) {
            return TargetRegistry.NONE;
        }
        TypeMirror registryClass = env.classType(classAnnotation::registryClass);
        List<TypeElement> classesToCheck = registryClass.getKind() == TypeKind.VOID ? List.of(env.typeElement("net.minecraftforge.registries.ForgeRegistries$Keys"), env.typeElement("net.minecraft.core.registries.Registries")) : List.of(env.typeElement(registryClass));
        for (TypeElement cls : classesToCheck) {
            for (Element element : cls.getEnclosedElements()) {
                VariableElement field;
                if (element.getKind() != ElementKind.FIELD || !element.getModifiers().contains((Object)Modifier.PUBLIC) || !element.getModifiers().contains((Object)Modifier.STATIC) || !element.getModifiers().contains((Object)Modifier.FINAL) || !(element instanceof VariableElement) || !(field = (VariableElement)element).getSimpleName().contentEquals(classAnnotation.registry()) || !env.sameErasure(env.forClass("net.minecraft.resources.ResourceKey"), field.asType())) continue;
                TypeMirror generic = RegisterClassProcessor.generic(field, field.asType(), "Registry key has invalid type", env);
                if (!env.sameErasure(env.forClass("net.minecraft.core.Registry"), generic)) {
                    env.messager().printMessage(Diagnostic.Kind.ERROR, "Registry key is not a root key or has too generic type: " + generic);
                    throw new FailureException();
                }
                TypeMirror elemType = RegisterClassProcessor.generic(field, generic, "Registry key has invalid element type", env);
                return new TargetRegistry(elemType, cls.getQualifiedName().toString() + "." + element.getSimpleName().toString());
            }
        }
        env.messager().printMessage(Diagnostic.Kind.ERROR, "Failed to resolve target registry: " + (String)(registryClass.getKind() == TypeKind.VOID ? "" : registryClass + ".") + classAnnotation.registry(), classElem);
        throw new FailureException();
    }

    private static TypeMirror generic(Element elem, TypeMirror type, String error, ModEnv env) {
        DeclaredType declared;
        if (type.getKind() == TypeKind.DECLARED && type instanceof DeclaredType && (declared = (DeclaredType)type).getTypeArguments().size() == 1) {
            WildcardType wildcard;
            TypeMirror genericType = declared.getTypeArguments().get(0);
            if (genericType.getKind() == TypeKind.WILDCARD && genericType instanceof WildcardType && (wildcard = (WildcardType)genericType).getExtendsBound() != null) {
                return wildcard.getExtendsBound();
            }
            return genericType;
        }
        env.messager().printMessage(Diagnostic.Kind.ERROR, error + ": " + type, elem);
        throw new FailureException();
    }

    private static Stream<RegistrationEntry> fromElement(RegisterClass classAnnotation, Element element, TargetRegistry target, ModEnv env) {
        Object name;
        if (element.getKind() != ElementKind.FIELD || element.getAnnotation(Reg.Exclude.class) != null) {
            return Stream.empty();
        }
        Element element2 = element.getEnclosingElement();
        if (!(element2 instanceof QualifiedNameable)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Failed to get qualified name for member: " + element, element.getEnclosingElement());
            return Stream.empty();
        }
        QualifiedNameable qualified = (QualifiedNameable)element2;
        if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
            env.messager().printMessage(Diagnostic.Kind.WARNING, "Skipping non-static field for automatic registration. Use @Reg.Exclude to suppress.", element);
            return Stream.empty();
        }
        if (!element.getModifiers().contains((Object)Modifier.FINAL)) {
            env.messager().printMessage(Diagnostic.Kind.WARNING, "Skipping non-final field for automatic registration. Use @Reg.Exclude to suppress.", element);
            return Stream.empty();
        }
        if (!element.getModifiers().contains((Object)Modifier.PUBLIC) && !element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            env.messager().printMessage(Diagnostic.Kind.WARNING, "Skipping non-public and non-private member for automatic registration. Use @Reg.Exclude to suppress.", element);
            return Stream.empty();
        }
        if (env.elements().getAllAnnotationMirrors(env.typeElement(element.asType())).stream().anyMatch(mirror -> env.sameErasure(mirror.getAnnotationType(), env.forClass(PlainRegisterable.class)))) {
            target = TargetRegistry.NONE;
        }
        if (target.baseType != null && !env.types().isSubtype(element.asType(), target.baseType)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Field has invalid type for target registry: expected " + target.baseType, element);
            return Stream.empty();
        }
        if (element.getAnnotation(Reg.Name.class) != null) {
            name = element.getAnnotation(Reg.Name.class).value();
        } else {
            StringBuilder sb = new StringBuilder();
            for (char chr : element.getSimpleName().toString().toCharArray()) {
                if (Character.isUpperCase(chr)) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(chr));
            }
            name = sb.toString();
        }
        if (!classAnnotation.prefix().isEmpty()) {
            name = classAnnotation.prefix() + "_" + (String)name;
        }
        return Stream.of(new RegistrationEntry(target.fqn(), (String)name, qualified.getQualifiedName().toString(), element.getSimpleName().toString()));
    }

    private record TargetRegistry(@Nullable TypeMirror baseType, @Nullable String fqn) {
        public static final TargetRegistry NONE = new TargetRegistry(null, null);
    }
}

