/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.network.SItemPopTimePacket;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PacketHandler;
import snownee.kiwi.util.KHolder;

@KiwiPacket(value="convert_item", dir=KiwiPacket.Direction.PLAY_TO_SERVER)
public class CConvertItemPacket
extends PacketHandler {
    public static final int MAX_STEPS = 4;
    public static CConvertItemPacket I;

    public static void send(boolean inContainer, int slot, Entry entry, Item from, Action action) {
        I.sendToServer(buf -> {
            buf.writeBoolean(inContainer);
            buf.m_130068_((Enum)action);
            buf.m_130130_(slot);
            buf.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)from);
            buf.m_130130_(entry.steps().size());
            for (Pair<ResourceLocation, Item> step : entry.steps()) {
                buf.m_130085_((ResourceLocation)step.getFirst());
                buf.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)((Item)step.getSecond()));
            }
        });
    }

    @Override
    public CompletableFuture<FriendlyByteBuf> receive(Function<Runnable, CompletableFuture<FriendlyByteBuf>> executor, FriendlyByteBuf buf, @Nullable ServerPlayer player) {
        boolean inContainer = buf.readBoolean();
        Action action = (Action)buf.m_130066_(Action.class);
        int slotIndex = buf.m_130242_();
        Item from = (Item)buf.m_236816_((IdMap)BuiltInRegistries.f_257033_);
        if (from == null) {
            return null;
        }
        int size = buf.m_130242_();
        ArrayList steps = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation familyId = buf.m_130281_();
            Item item = (Item)buf.m_236816_((IdMap)BuiltInRegistries.f_257033_);
            if (item == null) {
                return null;
            }
            steps.add(Pair.of((Object)familyId, (Object)item));
        }
        if (steps.isEmpty() || steps.size() > 4) {
            return null;
        }
        Item to = (Item)((Pair)steps.get(steps.size() - 1)).getSecond();
        if (action == Action.CONVERT_FAMILY && inContainer) {
            return null;
        }
        return executor.apply(() -> {
            ItemStack newItem;
            ItemStack sourceItem;
            Objects.requireNonNull(player);
            Item item = from;
            int index = 0;
            float ratio = 1.0f;
            for (Pair step : steps) {
                BlockFamily family = BlockFamilies.get((ResourceLocation)step.getFirst());
                if (!(family != null && family.switchAttrs().enabled() && family.contains(item) && family.contains((Item)step.getSecond()))) {
                    return;
                }
                if (!family.switchAttrs().cascading() && index != steps.size() - 1) {
                    return;
                }
                if (!player.m_7500_()) {
                    ratio *= BlockFamilies.getConvertRatio(item) / BlockFamilies.getConvertRatio((Item)step.getSecond());
                }
                item = (Item)step.getSecond();
                ++index;
            }
            Slot slot = null;
            Inventory playerInventory = player.m_150109_();
            try {
                if (slotIndex == -500) {
                    if (!player.m_7500_()) return;
                    sourceItem = from.m_7968_();
                } else if (inContainer) {
                    slot = (Slot)player.f_36096_.f_38839_.get(slotIndex);
                    if (!slot.m_150651_((Player)player)) {
                        return;
                    }
                    sourceItem = slot.m_7993_();
                } else {
                    sourceItem = playerInventory.m_8020_(slotIndex);
                }
            }
            catch (Exception e) {
                return;
            }
            if (!sourceItem.m_150930_(from)) {
                return;
            }
            if (action == Action.CONVERT_FAMILY) {
                CConvertItemPacket.convertFamily(player, to, slotIndex, ratio);
                return;
            }
            boolean skipSettingSlot = false;
            int inventorySwap = Integer.MIN_VALUE;
            if (ratio >= 1.0f) {
                newItem = to.m_7968_();
            } else {
                if (action == Action.CONVERT_ONE) {
                    return;
                }
                for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                    ItemStack stack = playerInventory.m_8020_(i);
                    if (!stack.m_150930_(to)) continue;
                    inventorySwap = i;
                    break;
                }
                if (inventorySwap == Integer.MIN_VALUE) {
                    return;
                }
                newItem = playerInventory.m_8020_(inventorySwap);
            }
            int ratioInt = Mth.m_14143_((float)ratio);
            if (action == Action.CONVERT_ONE) {
                if (!player.m_7500_()) {
                    sourceItem.m_41774_(1);
                    newItem.m_41764_(ratioInt);
                }
                if (!sourceItem.m_41619_()) {
                    CConvertItemPacket.addToPlayer(player, newItem, !inContainer);
                    skipSettingSlot = true;
                }
            } else if (inventorySwap == Integer.MIN_VALUE) {
                int maxSize = newItem.m_41741_();
                int count = Math.min(sourceItem.m_41613_(), maxSize / ratioInt);
                newItem.m_41764_(count * ratioInt);
                if (!player.m_7500_()) {
                    sourceItem.m_41774_(count);
                }
            }
            if (slotIndex != -500 && !skipSettingSlot) {
                try {
                    if (inContainer) {
                        if (!slot.m_5857_(newItem)) {
                            return;
                        }
                        slot.m_269060_(newItem);
                    } else {
                        newItem.m_41754_(5);
                        playerInventory.m_6836_(slotIndex, newItem);
                    }
                }
                catch (Exception e) {
                    return;
                }
            }
            if (inventorySwap != Integer.MIN_VALUE) {
                playerInventory.m_6836_(inventorySwap, sourceItem);
            } else if (!skipSettingSlot && !player.m_7500_()) {
                CConvertItemPacket.addToPlayer(player, sourceItem.m_41777_(), !inContainer);
            }
            CConvertItemPacket.broadcastChanges(player);
            CConvertItemPacket.playPickupSound((Player)player);
            player.f_36096_.m_38946_();
        });
    }

    private static void broadcastChanges(ServerPlayer player) {
        Inventory inventory = player.m_150109_();
        boolean success = false;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            success |= SItemPopTimePacket.send(player, i);
        }
        if (success) {
            CConvertItemPacket.playPickupSound((Player)player);
            player.f_36096_.m_38946_();
        }
    }

    public static void convertFamily(ServerPlayer player, Item to, int slotIndex, float ratio) {
        Set set = BlockFamilies.findQuickSwitch(to, player.m_7500_()).stream().map(KHolder::value).flatMap(BlockFamily::items).filter(Predicate.not(to::equals)).collect(Collectors.toSet());
        Inventory inventory = player.m_150109_();
        boolean success = false;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!set.contains(stack.m_41720_())) continue;
            success = true;
            inventory.m_6836_(i, ItemStack.f_41583_);
            ItemStack newItem = to.m_7968_();
            newItem.m_41754_(5);
            int newCount = Mth.m_14143_((float)((float)stack.m_41613_() * ratio));
            while (newCount > 0) {
                int count = Math.min(newCount, newItem.m_41741_());
                newItem.m_41764_(count);
                newCount -= count;
                if (!inventory.m_36040_(slotIndex, newItem) && !inventory.m_36054_(newItem)) {
                    player.m_36176_(newItem, true);
                }
                if (newCount <= 0) continue;
                newItem = newItem.m_41777_();
            }
        }
        if (success) {
            CConvertItemPacket.broadcastChanges(player);
        }
    }

    private static void addToPlayer(ServerPlayer player, ItemStack itemStack, boolean nextToSelected) {
        int slot;
        Inventory inventory = player.m_150109_();
        IntStream intStream = IntStream.range(0, 9);
        if (nextToSelected) {
            IntStream leftAndRight = IntStream.of(inventory.f_35977_, inventory.f_35977_ + 1, inventory.f_35977_ - 1);
            intStream = IntStream.concat(leftAndRight, intStream);
        }
        if (!(inventory.m_36040_(slot = intStream.filter(Inventory::m_36045_).filter(i -> {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) {
                return true;
            }
            return stack.m_41613_() < stack.m_41741_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack);
        }).findFirst().orElse(-1), itemStack) || inventory.m_36054_(itemStack) || player.m_7500_())) {
            player.m_36176_(itemStack, true);
        }
    }

    public static void playPickupSound(Player player) {
        player.m_9236_().m_6263_((Player)(player.m_7578_() ? player : null), player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
    }

    public static enum Action {
        CONVERT_ALL,
        CONVERT_ONE,
        CONVERT_FAMILY;

        private static final IntFunction<Action> BY_ID;

        static {
            BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])Action.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    public record Entry(float ratio, List<Pair<ResourceLocation, Item>> steps) {
        public Entry(float ratio) {
            this(ratio, Lists.newArrayList());
        }

        public Item item() {
            return (Item)this.steps.get(this.steps.size() - 1).getSecond();
        }
    }

    public record Group(LinkedHashSet<Entry> entries) {
        public Group() {
            this(Sets.newLinkedHashSet());
        }
    }
}

