/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.compat.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import java.util.ArrayList;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.block.family.StonecutterRecipeMaker;
import snownee.kiwi.customization.compat.emi.KEmiStonecutterRecipe;
import snownee.kiwi.util.KHolder;

@EmiEntrypoint
public class EMICompat
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        if (CustomizationHooks.isEnabled()) {
            ArrayList recipes = Lists.newArrayList();
            for (KHolder<BlockFamily> holder : BlockFamilies.all()) {
                BlockFamily family = holder.value();
                if (family.stonecutterSource().isPresent()) {
                    recipes.addAll(StonecutterRecipeMaker.makeRecipes("to", holder));
                }
                if (!family.stonecutterExchange()) continue;
                recipes.addAll(StonecutterRecipeMaker.makeRecipes("exchange_in_viewer", holder));
            }
            for (StonecutterRecipe recipe : recipes) {
                registry.addRecipe((EmiRecipe)new KEmiStonecutterRecipe(recipe));
            }
        }
    }
}

