/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.family;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.CustomizationHooks;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.customization.block.family.BlockFamilyInferrer;
import snownee.kiwi.customization.block.family.StonecutterRecipeMaker;
import snownee.kiwi.util.KHolder;
import snownee.kiwi.util.resource.OneTimeLoader;

public class BlockFamilies {
    private static ImmutableListMultimap<Item, KHolder<BlockFamily>> byItem = ImmutableListMultimap.of();
    private static ImmutableList<KHolder<BlockFamily>> fromResources = ImmutableList.of();
    private static ImmutableMap<ResourceLocation, KHolder<BlockFamily>> byId = ImmutableMap.of();
    private static ImmutableListMultimap<Item, KHolder<BlockFamily>> byStonecutterSource = ImmutableListMultimap.of();

    public static Collection<KHolder<BlockFamily>> find(Item item) {
        if (item == Items.f_41852_) {
            return List.of();
        }
        return byItem.get((Object)item);
    }

    public static List<KHolder<BlockFamily>> findQuickSwitch(Item item, boolean creative) {
        Stream<KHolder<BlockFamily>> stream = BlockFamilies.find(item).stream();
        stream = creative ? stream.filter(f -> ((BlockFamily)f.value()).switchAttrs().enabled()) : stream.filter(f -> ((BlockFamily)f.value()).switchAttrs().enabled() && !((BlockFamily)f.value()).switchAttrs().creativeOnly());
        return stream.toList();
    }

    public static Collection<KHolder<BlockFamily>> findByStonecutterSource(Item item) {
        return byStonecutterSource.get((Object)item);
    }

    public static void reloadResources(ResourceManager resourceManager, OneTimeLoader.Context context) {
        Map<ResourceLocation, BlockFamily> families = OneTimeLoader.load(resourceManager, "kiwi/family", BlockFamily.DIRECT_CODEC, context);
        fromResources = (ImmutableList)families.entrySet().stream().map(e -> new KHolder<BlockFamily>((ResourceLocation)e.getKey(), (BlockFamily)e.getValue())).collect(ImmutableList.toImmutableList());
        BlockFamilies.reloadComplete(List::of);
    }

    public static int reloadTags() {
        if (CustomizationHooks.kswitch) {
            BlockFamilies.reloadComplete(new BlockFamilyInferrer()::generate);
        }
        return byId.size();
    }

    private static void reloadComplete(Supplier<Collection<KHolder<BlockFamily>>> additionalSupplier) {
        byId = ImmutableMap.of();
        byItem = ImmutableListMultimap.of();
        byStonecutterSource = ImmutableListMultimap.of();
        Collection<KHolder<BlockFamily>> additional = additionalSupplier.get();
        HashMap byIdBuilder = Maps.newHashMapWithExpectedSize((int)(fromResources.size() + additional.size()));
        ImmutableListMultimap.Builder byItemBuilder = ImmutableListMultimap.builder();
        ImmutableListMultimap.Builder byStonecutterBuilder = ImmutableListMultimap.builder();
        for (KHolder family : Iterables.concat(fromResources, additional)) {
            KHolder old = byIdBuilder.putIfAbsent(family.key(), family);
            if (old != null) {
                Kiwi.LOGGER.error("Duplicate family {}", (Object)family);
                continue;
            }
            for (Holder.Reference<Item> item : ((BlockFamily)family.value()).itemHolders()) {
                byItemBuilder.put((Object)((Item)item.m_203334_()), (Object)family);
            }
            Optional<Holder.Reference<Item>> stonecutterSource = ((BlockFamily)family.value()).stonecutterSource();
            if (!stonecutterSource.isPresent()) continue;
            byStonecutterBuilder.put((Object)((Item)stonecutterSource.get().m_203334_()), (Object)family);
        }
        byId = ImmutableMap.copyOf((Map)byIdBuilder);
        byItem = byItemBuilder.build();
        byStonecutterSource = byStonecutterBuilder.build();
        StonecutterRecipeMaker.invalidateCache();
    }

    @Nullable
    public static BlockFamily get(ResourceLocation id) {
        KHolder holder = (KHolder)byId.get((Object)id);
        return holder == null ? null : (BlockFamily)holder.value();
    }

    public static Collection<KHolder<BlockFamily>> all() {
        return byId.values();
    }

    public static float getConvertRatio(Item item) {
        Block block = Block.m_49814_((Item)item);
        if (block == Blocks.f_50016_) {
            return 1.0f;
        }
        Holder holder = BuiltInRegistries.f_256975_.m_263177_((Object)block);
        if (holder.m_203656_(BlockTags.f_13031_)) {
            return 0.5f;
        }
        if (holder.m_203656_(BlockTags.f_13103_)) {
            return 2.0f;
        }
        if (holder.m_203656_(BlockTags.f_13036_)) {
            return 3.0f;
        }
        if (holder.m_203656_(BlockTags.f_13055_)) {
            return 4.0f;
        }
        if (holder.m_203656_(BlockTags.f_13099_)) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Nullable
    public static ResourceLocation getKey(BlockFamily family) {
        for (KHolder<BlockFamily> holder : BlockFamilies.all()) {
            if (holder.value() != family) continue;
            return holder.key();
        }
        return null;
    }
}

