/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.widget;

import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class WidgetBuilder<T> {
    protected static final Supplier<Minecraft> CLIENT = Minecraft::m_91087_;
    protected final IConfigEntry<T> config;
    protected StringWidget textWidget;
    protected Button resetButton;
    protected boolean canSave = true;

    protected WidgetBuilder(IConfigEntry<T> config) {
        this.config = config;
    }

    public void addDialogElements(Consumer<AbstractWidget> appender, String text, int x, int y, int width, int height) {
        Font textRenderer = WidgetBuilder.CLIENT.get().f_91062_;
        this.textWidget = new StringWidget(20, y, textRenderer.m_92895_(text), height, Component.m_130674_((String)text), textRenderer);
        appender.accept((AbstractWidget)this.textWidget);
        this.resetButton = Button.m_253074_((Component)Component.m_237115_((String)"jupiter.screen.button.remove"), button -> {
            this.config.reset();
            this.refresh();
        }).m_252987_(x + width - 50, y, 50, height).m_253136_();
        this.refreshResetButton(true);
        appender.accept((AbstractWidget)this.resetButton);
        this.addCustomElements(appender, x, y, width - 55, height);
    }

    public void addElements(Consumer<AbstractWidget> appender, int x, int y, int width, int height) {
        String name = this.config.getPrettyName();
        Font textRenderer = WidgetBuilder.CLIENT.get().f_91062_;
        this.textWidget = new StringWidget(20, y, textRenderer.m_92895_(name), height, Component.m_130674_((String)name), textRenderer);
        appender.accept((AbstractWidget)this.textWidget);
        this.resetButton = Button.m_253074_((Component)Component.m_237115_((String)"jupiter.screen.button.reset"), button -> {
            this.config.reset();
            this.refresh();
        }).m_252987_(x + width - 50, y, 50, height).m_253136_();
        this.refreshResetButton(false);
        this.config.registerCallback(v -> this.refreshResetButton(false));
        appender.accept((AbstractWidget)this.resetButton);
        this.addCustomElements(appender, x, y, width - 55, height);
    }

    private void refreshResetButton(boolean dialog) {
        this.setCanReset(dialog || !this.config.getValue().equals(this.config.getDefaultValue()));
    }

    protected void setCanReset(boolean b) {
        this.resetButton.f_93623_ = b;
    }

    public abstract void addCustomElements(Consumer<AbstractWidget> var1, int var2, int var3, int var4, int var5);

    public void update(boolean visible, int y) {
        if (this.textWidget != null) {
            this.textWidget.f_93624_ = visible;
            this.textWidget.m_253211_(y);
        }
        if (this.resetButton != null) {
            this.resetButton.f_93624_ = visible;
            this.resetButton.m_253211_(y);
        }
        this.updateCustom(visible, y);
    }

    public abstract void updateCustom(boolean var1, int var2);

    public abstract void refresh();

    public boolean canSave() {
        return this.canSave;
    }
}

