/*
 * Decompiled with CFR 0.152.
 */
package com.leo.jstages.plugins.item_stages;

import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import java.util.function.Predicate;
import net.darkhax.itemstages.Restriction;
import net.darkhax.itemstages.RestrictionManager;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStagesKJS
extends KubeJSPlugin {
    public void registerBindings(BindingsEvent event) {
        if (!event.getType().isServer() && !event.getType().isClient()) {
            return;
        }
        if (!ModList.get().isLoaded("itemstages")) {
            return;
        }
        event.add("ItemStages", ItemStagesMethods.class);
    }

    public static interface ItemStagesMethods {
        public static Restriction restrictEnchantment(Enchantment enchantment, String ... stages) {
            return ItemStagesMethods.restrictEnchantment(enchantment, true, true, stages);
        }

        public static Restriction restrictEnchantment(Enchantment enchantment, boolean checkBook, boolean checkItem, String ... stages) {
            return ItemStagesMethods.restrictItemInternal(item -> ItemStagesMethods.checkItemEnchantment(item, enchantment, checkBook, checkItem), stages);
        }

        public static Restriction restrictMod(String modid, String ... stages) {
            return ItemStagesMethods.restrictMod(modid, null, stages);
        }

        public static Restriction restrictMod(String modid, Predicate<ItemStack> toIgnore, String ... stages) {
            if (toIgnore == null) {
                return ItemStagesMethods.restrictItemInternal(item -> modid.equalsIgnoreCase(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()).m_135827_()), stages);
            }
            return ItemStagesMethods.restrictItemInternal(item -> modid.equalsIgnoreCase(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()).m_135827_()) && !toIgnore.test((ItemStack)item), stages);
        }

        public static Restriction restrictRarity(Rarity rarity, String ... stages) {
            return ItemStagesMethods.restrictItemInternal(item -> item.m_41791_() == rarity, stages);
        }

        public static Restriction restrictItem(InputItem item, String ... stages) {
            return ItemStagesMethods.restrictItemInternal((Predicate<ItemStack>)item.ingredient, stages);
        }

        public static Restriction restrictIngredient(Ingredient ingredient, String ... stages) {
            return ItemStagesMethods.restrictItemInternal((Predicate<ItemStack>)ingredient, stages);
        }

        private static Restriction restrictItemInternal(Predicate<ItemStack> item, String ... stages) {
            return ItemStagesMethods.createRestriction(stages).restrict(item);
        }

        public static Restriction createRestriction(String ... stages) {
            if (stages.length == 0) {
                throw new IllegalArgumentException("[JStages ItemStages]: Cannot create a restriction with 0 stages!");
            }
            Restriction restriction = new Restriction(stages);
            RestrictionManager.INSTANCE.addRestriction(restriction);
            return restriction;
        }

        private static boolean checkItemEnchantment(ItemStack stack, Enchantment enchantment, boolean checkBook, boolean checkItem) {
            if (!stack.m_41782_()) {
                return false;
            }
            if (checkBook && stack.m_41720_() instanceof EnchantedBookItem && EnchantmentHelper.m_44831_((ItemStack)stack).getOrDefault(enchantment, 0) > 0) {
                return true;
            }
            return checkItem && stack.getEnchantmentLevel(enchantment) > 0;
        }
    }
}

