/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages.jei;

import com.ibm.icu.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.event.StagesSyncedEvent;
import net.darkhax.itemstages.ItemStages;
import net.darkhax.itemstages.Restriction;
import net.darkhax.itemstages.RestrictionManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.util.thread.EffectiveSide;

@OnlyIn(value=Dist.CLIENT)
@JeiPlugin
public class PluginItemStages
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = new ResourceLocation("itemstages", "main");
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");
    private IJeiRuntime runtime;
    private final List<ItemStack> hiddenItems = new ArrayList<ItemStack>();

    public PluginItemStages() {
        if (EffectiveSide.get().isClient()) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, StagesSyncedEvent.class, e -> this.updateHiddenItems());
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, RecipesUpdatedEvent.class, e -> this.updateHiddenItems());
        }
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.runtime = jeiRuntime;
    }

    private void updateHiddenItems() {
        Minecraft.m_91087_().execute(() -> {
            if (this.runtime != null) {
                this.runtime.getIngredientManager();
                long syncStart = System.nanoTime();
                IIngredientManager ingredients = this.runtime.getIngredientManager();
                ItemStages.LOGGER.debug("Syncing JEI with ItemStages.");
                this.restoreStagedItems(ingredients);
                this.collectStagedIngredients(ingredients);
                this.hideStagedIngredients(ingredients);
                ItemStages.LOGGER.debug("JEI has been synced with ItemStages. Took {}ms.", (Object)FORMAT.format((System.nanoTime() - syncStart) / 1000000L));
            }
        });
    }

    private void restoreStagedItems(IIngredientManager ingredients) {
        long restoreStart = System.nanoTime();
        ItemStages.LOGGER.debug("Restoring {} hidden items.", (Object)this.hiddenItems.size());
        if (!this.hiddenItems.isEmpty()) {
            ingredients.addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.hiddenItems);
            this.hiddenItems.clear();
        }
        ItemStages.LOGGER.debug("Items list restored. Took {}ms.", (Object)FORMAT.format((System.nanoTime() - restoreStart) / 1000000L));
    }

    private void collectStagedIngredients(IIngredientManager ingredients) {
        ItemStages.LOGGER.debug("Calculating items to hide.");
        long hideCalcStart = System.nanoTime();
        RestrictionManager restrictions = RestrictionManager.INSTANCE;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        IStageData stageData = GameStageHelper.getPlayerData((Player)player);
        for (ItemStack ingredient : ingredients.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
            Restriction restriction = restrictions.getRestriction((Player)player, stageData, ingredient);
            if (restriction == null || !restriction.shouldHideInJEI()) continue;
            this.hiddenItems.add(ingredient);
        }
        ItemStages.LOGGER.debug("Marked {} entries for hiding. Took {}ms.", (Object)this.hiddenItems.size(), (Object)FORMAT.format((System.nanoTime() - hideCalcStart) / 1000000L));
    }

    private void hideStagedIngredients(IIngredientManager ingredients) {
        ItemStages.LOGGER.debug("Hiding {} entries from JEI.", (Object)this.hiddenItems.size());
        long hideStart = System.nanoTime();
        if (!this.hiddenItems.isEmpty()) {
            ingredients.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.hiddenItems);
        }
        ItemStages.LOGGER.debug("All entries hidden. Took {}ms.", (Object)FORMAT.format((System.nanoTime() - hideStart) / 1000000L));
    }
}

