/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.itemstages.Restriction;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RestrictionManager
extends SimplePreparableReloadListener<Void> {
    public static final RestrictionManager INSTANCE = new RestrictionManager();
    private final Multimap<String, Restriction> restrictions = HashMultimap.create();
    private final Multimap<String, Restriction> preventInventory = HashMultimap.create();
    private final Multimap<String, Restriction> preventEquipment = HashMultimap.create();
    private boolean hasBuiltCaches = false;

    private void buildCaches() {
        if (!this.hasBuiltCaches) {
            for (String stage : this.restrictions.keySet()) {
                for (Restriction restriction : this.restrictions.get((Object)stage)) {
                    if (restriction.shouldPreventInventory()) {
                        this.preventInventory.put((Object)stage, (Object)restriction);
                    }
                    if (!restriction.shouldPreventEquipment()) continue;
                    this.preventEquipment.put((Object)stage, (Object)restriction);
                }
            }
            this.hasBuiltCaches = true;
        }
    }

    @Nullable
    public Restriction getRestriction(Player player, ItemStack stack) {
        return this.getRestriction(player, GameStageHelper.getPlayerData((Player)player), stack, this.restrictions);
    }

    @Nullable
    public Restriction getRestriction(Player player, IStageData stageData, ItemStack stack) {
        return this.getRestriction(player, stageData, stack, this.restrictions);
    }

    @Nullable
    public Restriction getInventoryRestriction(Player player, IStageData stageData, ItemStack stack) {
        return this.getRestriction(player, stageData, stack, this.preventInventory);
    }

    @Nullable
    public Restriction getEquipmentRestriction(Player player, IStageData stageData, ItemStack stack) {
        return this.getRestriction(player, stageData, stack, this.preventEquipment);
    }

    @Nullable
    public Restriction getRestriction(Player player, IStageData stageData, ItemStack stack, Multimap<String, Restriction> restrictionPool) {
        if (!stack.m_41619_()) {
            this.buildCaches();
            for (String stageName : restrictionPool.keySet()) {
                if (GameStageHelper.hasStage((Player)player, (IStageData)stageData, (String)stageName)) continue;
                for (Restriction restriction : restrictionPool.get((Object)stageName)) {
                    if (!restriction.isRestricted(stack) || restriction.meetsRequirements(player, stageData)) continue;
                    return restriction;
                }
            }
        }
        return null;
    }

    public void addRestriction(Restriction restriction) {
        restriction.getStages().forEach(stage -> this.restrictions.put(stage, (Object)restriction));
    }

    protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        return null;
    }

    protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.hasBuiltCaches = false;
        this.restrictions.clear();
        this.preventInventory.clear();
    }
}

