/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import net.minecraftforge.energy.IEnergyStorage;

public record WrappingEnergyStorage(IEnergyStorage base, boolean allowInsert, boolean allowExtract, Runnable afterTransfer) implements IEnergyStorage
{
    public WrappingEnergyStorage(IEnergyStorage base, boolean allowInsert, boolean allowExtract) {
        this(base, allowInsert, allowExtract, () -> {});
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.allowInsert) {
            return this.postTransfer(this.base.receiveEnergy(maxReceive, simulate), simulate);
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.allowExtract) {
            return this.postTransfer(this.base.extractEnergy(maxExtract, simulate), simulate);
        }
        return 0;
    }

    public int getEnergyStored() {
        return this.base.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.base.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.allowExtract;
    }

    public boolean canReceive() {
        return this.allowInsert;
    }

    private int postTransfer(int transferred, boolean simulate) {
        if (!simulate && transferred > 0) {
            this.afterTransfer.run();
        }
        return transferred;
    }
}

