/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.command.GenerateModelCommand;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GiveModelCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_MODEL_TIER = (ctx, builder) -> SharedSuggestionProvider.m_82981_(Arrays.stream(ModelTier.values()).map(t -> t.name().toLowerCase(Locale.ROOT)), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        root.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"give_model").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"model", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(GenerateModelCommand.SUGGEST_DATA_MODEL).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"tier", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_MODEL_TIER).executes(c -> GiveModelCommand.giveItem((CommandSourceStack)c.getSource(), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"model"), EntityArgument.m_91477_((CommandContext)c, (String)"targets"), StringArgumentType.getString((CommandContext)c, (String)"tier"), 0))).then(Commands.m_82129_((String)"data", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(c -> GiveModelCommand.giveItem((CommandSourceStack)c.getSource(), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"model"), EntityArgument.m_91477_((CommandContext)c, (String)"targets"), StringArgumentType.getString((CommandContext)c, (String)"tier"), IntegerArgumentType.getInteger((CommandContext)c, (String)"data"))))))));
    }

    private static int giveItem(CommandSourceStack pSource, ResourceLocation modelId, Collection<ServerPlayer> pTargets, String tierName, int bonusData) throws CommandSyntaxException {
        DataModel model = (DataModel)DataModelRegistry.INSTANCE.getValue(modelId);
        if (model == null) {
            pSource.m_81352_((Component)Component.m_237113_((String)("Invalid model: " + modelId)));
            return 0;
        }
        try {
            ModelTier tier = ModelTier.valueOf(tierName.toUpperCase(Locale.ROOT));
            int data = tier.data().requiredData();
        }
        catch (Exception ex) {
            pSource.m_81352_((Component)Component.m_237113_((String)("Invalid model tier: " + tierName)));
            return -1;
        }
        ItemStack modelStack = new ItemStack((ItemLike)Hostile.Items.DATA_MODEL.get());
        DataModelItem.setStoredModel(modelStack, model);
        DataModelItem.setData(modelStack, data += bonusData);
        for (ServerPlayer serverplayer : pTargets) {
            ItemStack stack = modelStack.m_41777_();
            boolean flag = serverplayer.m_150109_().m_36054_(stack);
            if (flag && stack.m_41619_()) {
                stack.m_41764_(1);
                ItemEntity itementity1 = serverplayer.m_36176_(stack, false);
                if (itementity1 != null) {
                    itementity1.m_32065_();
                }
                serverplayer.m_9236_().m_6263_((Player)null, serverplayer.m_20185_(), serverplayer.m_20186_(), serverplayer.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((serverplayer.m_217043_().m_188501_() - serverplayer.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
                serverplayer.f_36096_.m_38946_();
                continue;
            }
            ItemEntity itementity = serverplayer.m_36176_(stack, false);
            if (itementity == null) continue;
            itementity.m_32061_();
            itementity.m_266426_(serverplayer.m_20148_());
        }
        if (pTargets.size() == 1) {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{1, modelStack.m_41611_(), ((ServerPlayer)pTargets.iterator().next()).m_5446_()}), true);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"commands.give.success.single", (Object[])new Object[]{1, modelStack.m_41611_(), pTargets.size()}), true);
        }
        return pTargets.size();
    }
}

