/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.entity;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.client.ParticleHandler;
import dev.shadowsoffire.gateways.event.GateEvent;
import dev.shadowsoffire.gateways.gate.GateRules;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.gateways.gate.SpawnAlgorithms;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.gateways.net.ParticleMessage;
import dev.shadowsoffire.placebo.network.PacketDistro;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class GatewayEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Boolean> WAVE_ACTIVE = SynchedEntityData.m_135353_(GatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> TICKS_ACTIVE = SynchedEntityData.m_135353_(GatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> WAVE = SynchedEntityData.m_135353_(GatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ENEMIES = SynchedEntityData.m_135353_(GatewayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected final Set<LivingEntity> currentWaveEntities = new HashSet<LivingEntity>();
    protected final Set<UUID> unresolvedWaveEntities = new HashSet<UUID>();
    protected UUID summonerId;
    protected DynamicHolder<? extends Gateway> gate;
    protected float clientScale = 0.0f;
    protected Queue<ItemStack> undroppedItems = new ArrayDeque<ItemStack>();
    protected FailureReason failureReason;
    @Nullable
    protected ServerBossEvent bossEvent;

    public GatewayEntity(EntityType<? extends GatewayEntity> type, Level level, Player placer, DynamicHolder<? extends Gateway> gate) {
        super(type, level);
        this.summonerId = placer.m_20148_();
        this.gate = gate;
        Preconditions.checkArgument((boolean)gate.isBound(), (Object)"A gateway may not be constructed for an unbound holder.");
        this.m_6593_((Component)Component.m_237115_((String)gate.getId().toString().replace(':', '.')).m_130948_(Style.f_131099_.m_131148_(((Gateway)gate.get()).color())));
        this.bossEvent = this.createBossEvent();
        this.m_6210_();
    }

    public GatewayEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public abstract Wave getCurrentWave();

    protected boolean canStartNextWave() {
        return this.getTicksActive() > this.getSetupTime();
    }

    public abstract boolean isCompleted();

    protected abstract void completeWave();

    public int getSetupTime() {
        return this.getCurrentWave().setupTime();
    }

    public int getMaxWaveTime() {
        return this.getCurrentWave().maxWaveTime();
    }

    /*
     * WARNING - void declaration
     */
    public void m_8119_() {
        if (!this.gate.isBound()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (!this.unresolvedWaveEntities.isEmpty()) {
                for (UUID uUID : this.unresolvedWaveEntities) {
                    Entity e2 = ((ServerLevel)this.m_9236_()).m_8791_(uUID);
                    if (!(e2 instanceof LivingEntity)) continue;
                    this.currentWaveEntities.add((LivingEntity)e2);
                }
                this.unresolvedWaveEntities.clear();
            }
            if (this.isWaveActive()) {
                int maxWaveTime = this.getMaxWaveTime();
                if (this.getTicksActive() > maxWaveTime) {
                    this.onFailure(this.currentWaveEntities, FailureReason.TIMER_ELAPSED);
                    return;
                }
            }
            this.f_19804_.m_135381_(TICKS_ACTIVE, (Object)(this.getTicksActive() + 1));
            List<LivingEntity> enemies = this.currentWaveEntities.stream().filter(e -> e.m_21223_() > 0.0f && !this.isValidRemoval(e.m_146911_())).toList();
            if (this.f_19797_ % 20 == 0) {
                for (LivingEntity entity : enemies) {
                    if (GatewayEntity.hasLeftDimension((Entity)entity)) {
                        this.onFailure(this.currentWaveEntities, FailureReason.ENTITY_LEFT_DIMENSION);
                        return;
                    }
                    if (entity.m_146911_() == Entity.RemovalReason.DISCARDED) {
                        this.onFailure(this.currentWaveEntities, FailureReason.ENTITY_DISCARDED);
                        return;
                    }
                    if (entity.f_19797_ > 30) {
                        this.spawnParticle(entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), ParticleMessage.Type.IDLE);
                    }
                    if (!this.isOutOfRange((Entity)entity) || !this.getGateway().rules().failOnOutOfBounds() && this.respawnEntity((Entity)entity)) continue;
                    this.onFailure(this.currentWaveEntities, FailureReason.ENTITY_TOO_FAR);
                    return;
                }
            }
            this.f_19804_.m_135381_(ENEMIES, (Object)enemies.size());
            if (this.f_19797_ % 4 == 0 && !this.undroppedItems.isEmpty()) {
                void var2_7;
                boolean bl = false;
                while (var2_7 < this.getDropCount()) {
                    this.spawnItem(this.undroppedItems.remove());
                    if (this.undroppedItems.isEmpty()) break;
                    ++var2_7;
                }
            }
            if (this.isWaveActive()) {
                if (enemies.isEmpty()) {
                    this.completeWave();
                    MinecraftForge.EVENT_BUS.post((Event)new GateEvent.WaveEnd(this));
                    this.currentWaveEntities.clear();
                    this.f_19804_.m_135381_(WAVE_ACTIVE, (Object)false);
                    this.f_19804_.m_135381_(TICKS_ACTIVE, (Object)0);
                    this.f_19804_.m_135381_(WAVE, (Object)(this.getWave() + 1));
                }
            } else {
                if (this.canStartNextWave()) {
                    this.startNextWave();
                    this.f_19804_.m_135381_(WAVE_ACTIVE, (Object)true);
                    this.f_19804_.m_135381_(TICKS_ACTIVE, (Object)0);
                    this.f_19804_.m_135381_(ENEMIES, (Object)this.currentWaveEntities.size());
                    MinecraftForge.EVENT_BUS.post((Event)new GateEvent.WaveStarted(this));
                    return;
                }
                if (this.isCompleted()) {
                    this.completeGateway();
                }
            }
        } else if (this.f_19797_ % 30 == 0) {
            ParticleHandler.spawnIdleParticles(this);
        }
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return ((Gateway)this.gate.get()).size().getDims();
    }

    protected boolean isValidRemoval(@Nullable Entity.RemovalReason reason) {
        GateRules rules = this.getGateway().rules();
        return reason == Entity.RemovalReason.KILLED || rules.allowDiscarding() && reason == Entity.RemovalReason.DISCARDED || rules.allowDimChange() && reason == Entity.RemovalReason.CHANGED_DIMENSION;
    }

    protected int getDropCount() {
        return 3 + this.undroppedItems.size() / 100;
    }

    protected void startNextWave() {
        List<LivingEntity> spawned = this.getCurrentWave().spawnWave((ServerLevel)this.m_9236_(), this.m_20182_(), this);
        this.currentWaveEntities.addAll(spawned);
    }

    protected void completeGateway() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_5496_((SoundEvent)GatewayObjects.GATE_END.get(), 16.0f, 1.0f);
        this.m_9236_().m_45955_(TargetingConditions.f_26872_, null, this.m_20191_().m_82400_(15.0)).forEach(p -> p.m_36220_((ResourceLocation)GatewayObjects.GATES_DEFEATED.get()));
        MinecraftForge.EVENT_BUS.post((Event)new GateEvent.Completed(this));
    }

    public void onGateCreated() {
        this.m_5496_((SoundEvent)GatewayObjects.GATE_START.get(), 1.0f, 1.0f);
        MinecraftForge.EVENT_BUS.post((Event)new GateEvent.Opened(this));
    }

    public Player summonerOrClosest() {
        Player player;
        Player player2 = player = this.summonerId == null ? null : this.m_9236_().m_46003_(this.summonerId);
        if (player == null) {
            player = this.m_9236_().m_45930_((Entity)this, 50.0);
        }
        if (player == null) {
            return this.summonerId == null ? FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.m_9236_())) : FakePlayerFactory.get((ServerLevel)((ServerLevel)this.m_9236_()), (GameProfile)new GameProfile(this.summonerId, ""));
        }
        return player;
    }

    public void onFailure(Collection<LivingEntity> remaining, FailureReason reason) {
        this.failureReason = reason;
        MinecraftForge.EVENT_BUS.post((Event)new GateEvent.Failed(this));
        Player player = this.summonerOrClosest();
        if (player != null) {
            player.m_213846_(reason.getMsg());
        }
        GatewayEntity.spawnLightningOn(this, false);
        remaining.stream().filter(Entity::m_6084_).forEach(e -> {
            if (this.getGateway().rules().removeOnFailure()) {
                GatewayEntity.spawnLightningOn((Entity)e, true);
                e.m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (e instanceof Mob) {
                Mob mob = (Mob)e;
                mob.f_21353_ = false;
            }
        });
        this.getGateway().failures().forEach(f -> f.onFailure((ServerLevel)this.m_9236_(), this, player, reason));
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected ServerBossEvent createBossEvent() {
        if (this.getGateway().bossSettings().drawAsBar()) {
            ServerBossEvent event = new ServerBossEvent((Component)Component.m_237113_((String)("GATEWAY_ID" + this.m_19879_())), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
            event.m_7006_(this.getGateway().bossSettings().fog());
            return event;
        }
        return null;
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("wave", this.getWave());
        tag.m_128359_("gate", this.gate.getId().toString());
        long[] ids = new long[this.currentWaveEntities.size() * 2];
        int idx = 0;
        for (LivingEntity e : this.currentWaveEntities) {
            UUID id = e.m_20148_();
            ids[idx++] = id.getMostSignificantBits();
            ids[idx++] = id.getLeastSignificantBits();
        }
        tag.m_128388_("wave_entities", ids);
        tag.m_128379_("active", this.isWaveActive());
        tag.m_128405_("ticks_active", this.getTicksActive());
        if (this.summonerId != null) {
            tag.m_128362_("summoner", this.summonerId);
        }
        ListTag stacks = new ListTag();
        for (ItemStack s : this.undroppedItems) {
            stacks.add((Object)s.serializeNBT());
        }
        tag.m_128365_("queued_stacks", (Tag)stacks);
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("wave")) {
            this.f_19804_.m_135381_(WAVE, (Object)tag.m_128451_("wave"));
        }
        if (tag.m_128441_("gate")) {
            this.gate = GatewayRegistry.INSTANCE.holder(new ResourceLocation(tag.m_128461_("gate")));
        }
        if (!this.gate.isBound()) {
            Gateways.LOGGER.error("Invalid gateway at {} will be removed.", (Object)this.m_20182_());
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (tag.m_128441_("wave_entities")) {
            this.currentWaveEntities.clear();
            this.unresolvedWaveEntities.clear();
            long[] entities = tag.m_128467_("wave_entities");
            for (int i = 0; i < entities.length; i += 2) {
                this.unresolvedWaveEntities.add(new UUID(entities[i], entities[i + 1]));
            }
        }
        if (tag.m_128441_("active")) {
            this.f_19804_.m_135381_(WAVE_ACTIVE, (Object)tag.m_128471_("active"));
        }
        if (tag.m_128441_("ticks_active")) {
            this.f_19804_.m_135381_(TICKS_ACTIVE, (Object)tag.m_128451_("ticks_active"));
        }
        if (tag.m_128441_("summoner")) {
            this.summonerId = tag.m_128342_("summoner");
        }
        if (tag.m_128441_("queued_stacks")) {
            this.undroppedItems.clear();
            ListTag stacks = tag.m_128437_("queued_stacks", 10);
            for (Tag inbt : stacks) {
                this.undroppedItems.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)inbt)));
            }
        }
        this.bossEvent = this.createBossEvent();
        this.m_6210_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(WAVE_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(TICKS_ACTIVE, (Object)0);
        this.f_19804_.m_135372_(WAVE, (Object)0);
        this.f_19804_.m_135372_(ENEMIES, (Object)0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        if (this.bossEvent != null) {
            this.bossEvent.m_6543_(player);
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        if (this.bossEvent != null) {
            this.bossEvent.m_6539_(player);
        }
    }

    public int getTicksActive() {
        return (Integer)this.f_19804_.m_135370_(TICKS_ACTIVE);
    }

    public boolean isWaveActive() {
        return (Boolean)this.f_19804_.m_135370_(WAVE_ACTIVE);
    }

    public int getWave() {
        return (Integer)this.f_19804_.m_135370_(WAVE);
    }

    public int getActiveEnemies() {
        return (Integer)this.f_19804_.m_135370_(ENEMIES);
    }

    public Gateway getGateway() {
        return (Gateway)this.gate.get();
    }

    public boolean isValid() {
        return this.gate.isBound();
    }

    @Nullable
    public ServerBossEvent getBossEvent() {
        return this.bossEvent;
    }

    public float getClientScale() {
        return this.clientScale;
    }

    public void setClientScale(float clientScale) {
        this.clientScale = clientScale;
    }

    public void spawnParticle(double x, double y, double z, ParticleMessage.Type type) {
        PacketDistro.sendToTracking((SimpleChannel)Gateways.CHANNEL, (Object)new ParticleMessage(this, x, y, z, this.getGateway().color(), type), (ServerLevel)((ServerLevel)this.m_9236_()), (BlockPos)new BlockPos((int)x, (int)y, (int)z));
    }

    public void spawnItem(ItemStack stack) {
        ItemEntity i = new ItemEntity(this.m_9236_(), 0.0, 0.0, 0.0, stack);
        i.m_6034_(this.m_20185_() + Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.5, (double)0.5), this.m_20186_() + 1.5, this.m_20189_() + Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.5, (double)0.5));
        i.m_20334_(Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.15, (double)0.15), 0.4, Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.15, (double)0.15));
        this.m_9236_().m_7967_((Entity)i);
        this.m_9236_().m_6263_(null, i.m_20185_(), i.m_20186_(), i.m_20189_(), (SoundEvent)GatewayObjects.GATE_WARP.get(), SoundSource.HOSTILE, 0.25f, 2.0f);
    }

    public void spawnCompletionItem(ItemStack stack) {
        ItemEntity i = new ItemEntity(this.m_9236_(), 0.0, 0.0, 0.0, stack);
        double variance = 0.05f * this.getGateway().size().getScale();
        i.m_6034_(this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_());
        i.m_20334_(Mth.m_216263_((RandomSource)this.f_19796_, (double)(-variance), (double)variance), (double)(this.m_20206_() / 20.0f), Mth.m_216263_((RandomSource)this.f_19796_, (double)(-variance), (double)variance));
        i.m_149678_();
        this.m_9236_().m_7967_((Entity)i);
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        buf.m_130085_(this.gate.getId());
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.gate = GatewayRegistry.INSTANCE.holder(buf.m_130281_());
        if (!this.gate.isBound()) {
            throw new RuntimeException("Invalid gateway received on client!");
        }
        this.m_6210_();
    }

    protected int m_8088_() {
        return 2;
    }

    @Nullable
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    public boolean isOutOfRange(Entity entity) {
        return entity.m_20280_((Entity)this) > this.getGateway().getLeashRangeSq();
    }

    public void handleConversion(Entity entity, LivingEntity outcome) {
        entity.getPersistentData().m_128473_("gateways.owner");
        outcome.getPersistentData().m_128362_("gateways.owner", this.m_20148_());
        if (this.unresolvedWaveEntities.contains(entity.m_20148_())) {
            this.unresolvedWaveEntities.remove(entity.m_20148_());
            this.unresolvedWaveEntities.add(outcome.m_20148_());
        } else if (this.currentWaveEntities.contains(entity)) {
            this.currentWaveEntities.remove(entity);
            this.currentWaveEntities.add(outcome);
        }
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean respawnEntity(Entity entity) {
        SpawnAlgorithms.SpawnAlgorithm algo = this.getGateway().spawnAlgo();
        Vec3 pos = algo.spawn((ServerLevel)this.m_9236_(), this.m_20182_(), this, entity);
        if (pos == null) {
            return false;
        }
        entity.m_183634_();
        this.spawnParticle(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ParticleMessage.Type.SPAWNED);
        entity.m_146884_(pos);
        this.spawnParticle(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ParticleMessage.Type.SPAWNED);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            Player p = this.summonerOrClosest();
            if (!(p instanceof FakePlayer)) {
                mob.m_6710_((LivingEntity)p);
            }
        }
        return true;
    }

    public static void spawnLightningOn(Entity entity, boolean effectOnly) {
        LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(entity.m_9236_());
        bolt.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        bolt.m_20874_(effectOnly);
        entity.m_9236_().m_7967_((Entity)bolt);
    }

    public static boolean hasLeftDimension(Entity entity) {
        return entity.m_146911_() == Entity.RemovalReason.CHANGED_DIMENSION;
    }

    @Nullable
    public static GatewayEntity getOwner(Entity entity) {
        if (entity.getPersistentData().m_128441_("gateways.owner")) {
            GatewayEntity gate;
            ServerLevel sl;
            UUID id = entity.getPersistentData().m_128342_("gateways.owner");
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel && (level = (sl = (ServerLevel)level).m_8791_(id)) instanceof GatewayEntity && (gate = (GatewayEntity)level).isValid()) {
                return gate;
            }
        }
        return null;
    }

    public static enum FailureReason {
        SPAWN_FAILED("error.gateways.wave_failed"),
        ENTITY_TOO_FAR("error.gateways.too_far"),
        TIMER_ELAPSED("error.gateways.wave_elapsed"),
        ENTITY_DISCARDED("error.gateways.entity_discarded"),
        ENTITY_LEFT_DIMENSION("error.gateways.left_dimension");

        private final String langKey;

        private FailureReason(String langKey) {
            this.langKey = langKey;
        }

        public Component getMsg() {
            return Component.m_237115_((String)this.langKey).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.UNDERLINE});
        }
    }
}

