/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gamestages;

import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.GameStageReloader;
import net.darkhax.gamestages.advancement.HasStageTrigger;
import net.darkhax.gamestages.command.GameStageCommands;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.packet.GameStagesPacketHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gamestages")
public class GameStages {
    public static final String MOD_ID = "gamestages";
    public static final Logger LOG = LogManager.getLogger((String)"Game Stages");
    public static final GameStagesPacketHandler NETWORK = new GameStagesPacketHandler();

    public GameStages() {
        GameStageSaveHandler.reloadFakePlayers();
        GameStageSaveHandler.reloadKnownStages();
        GameStageCommands.initializeCommands();
        if (FMLEnvironment.dist.isClient()) {
            MinecraftForge.EVENT_BUS.addListener(this::onF3Text);
        }
        MinecraftForge.EVENT_BUS.addListener(this::registerReloadListeners);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CriteriaTriggers.m_10595_((CriterionTrigger)HasStageTrigger.INSTANCE));
    }

    private void registerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new GameStageReloader());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onF3Text(CustomizeGuiOverlayEvent.DebugText event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92063_) {
            if (mc.f_91074_ != null && mc.f_91074_.m_6144_()) {
                IStageData data = GameStageHelper.getPlayerData((Player)mc.f_91074_);
                if (data != null) {
                    event.getRight().add(ChatFormatting.GOLD + ChatFormatting.UNDERLINE.toString() + "GameStages");
                    event.getRight().add("Count: " + data.getStages().size());
                    event.getRight().add("Type: " + data.getClass().getName());
                    event.getRight().add("Stages: " + data.getStages().toString());
                }
            } else {
                event.getRight().add(ChatFormatting.GOLD + ChatFormatting.UNDERLINE.toString() + "GameStages [Shift]");
            }
        }
    }
}

