/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.loot.modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.block.PieBlock;

public class PastrySlicingModifier
extends LootModifier {
    public static final Supplier<Codec<PastrySlicingModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> PastrySlicingModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("slice").forGetter(m -> m.pastrySlice)).apply((Applicative)inst, PastrySlicingModifier::new)));
    public static final int MAX_CAKE_BITES = 7;
    public static final int MAX_PIE_BITES = 4;
    private final Item pastrySlice;

    protected PastrySlicingModifier(LootItemCondition[] conditionsIn, Item pastrySliceIn) {
        super(conditionsIn);
        this.pastrySlice = pastrySliceIn;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (state != null) {
            Block targetBlock = state.m_60734_();
            if (targetBlock instanceof CakeBlock) {
                int bites = (Integer)state.m_61143_((Property)CakeBlock.f_51180_);
                generatedLoot.add((Object)new ItemStack((ItemLike)this.pastrySlice, 7 - bites));
            } else if (targetBlock instanceof PieBlock) {
                int bites = (Integer)state.m_61143_((Property)PieBlock.BITES);
                generatedLoot.add((Object)new ItemStack((ItemLike)this.pastrySlice, 4 - bites));
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

