/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.util;

import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ColorUtil {
    private static final long BIT_MASK = 255L;

    private static int clamp(int target, int fallback) {
        return target == Integer.MAX_VALUE ? fallback : target;
    }

    public static int mix(int[] start, int[] end, double blend) {
        return ColorUtil.pack(ColorUtil.lerp(start[0], end[0], blend), ColorUtil.lerp(start[1], end[1], blend), ColorUtil.lerp(start[2], end[2], blend), ColorUtil.lerp(start[3], end[3], blend));
    }

    public static int[] transformFloatColor(Vec3 floatColor) {
        return new int[]{255, (int)(floatColor.m_7096_() * 255.0), (int)(floatColor.m_7098_() * 255.0), (int)(floatColor.m_7094_() * 255.0)};
    }

    public static Vector3f glColor(int[] packedColor) {
        float r = (float)packedColor[1] / 255.0f;
        float g = (float)packedColor[2] / 255.0f;
        float b = (float)packedColor[3] / 255.0f;
        return new Vector3f(r, g, b);
    }

    private static int lerp(int start, int end, double blend) {
        return (int)((double)start + (double)(end - start) * blend);
    }

    public static int pack(int a, int r, int g, int b) {
        return (int)(((long)a & 0xFFL) << 24 | ((long)r & 0xFFL) << 16 | ((long)g & 0xFFL) << 8 | (long)b & 0xFFL);
    }

    public static int pack(int r, int g, int b) {
        return ColorUtil.pack(255, r, g, b);
    }

    public static int[] unpack(int decimal) {
        return new int[]{(int)((long)(decimal >> 24) & 0xFFL), (int)((long)(decimal >> 16) & 0xFFL), (int)((long)(decimal >> 8) & 0xFFL), (int)((long)decimal & 0xFFL)};
    }
}

