/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.entity;

import com.google.common.annotations.VisibleForTesting;
import dev.corgitaco.enhancedcelestials.core.ECEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class MeteorEntity
extends Entity {
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(MeteorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public MeteorEntity(Level level) {
        this(ECEntities.METEOR.get(), level);
    }

    public MeteorEntity(EntityType<? extends MeteorEntity> $$0, Level $$1) {
        super($$0, $$1);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.setSize(compoundTag.m_128457_("Size"));
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128350_("Size", this.getSize());
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 velocity = this.m_20184_();
        this.m_20256_(velocity.m_82492_(0.0, 0.3, 0.0));
        this.m_6478_(MoverType.SELF, velocity);
        if (!this.m_9236_().f_46443_) {
            if (this.m_20096_() || this.f_19863_ || this.f_19862_) {
                this.m_146870_();
                this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f, Level.ExplosionInteraction.TNT);
            }
        } else {
            Vec3 reverse = this.m_20184_().m_82542_(-1.0, -1.0, -1.0);
            float bbWidth = this.m_20205_() / 2.0f;
            for (float xOffset = -bbWidth; xOffset <= bbWidth; xOffset += 1.0f) {
                for (float zOffset = -bbWidth; zOffset <= bbWidth; zOffset += 1.0f) {
                    for (int i = 0; i < 5; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (double)xOffset, this.m_20186_() + Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.4, (double)0.4), this.m_20189_() + (double)zOffset, reverse.m_7096_(), reverse.m_7098_(), reverse.m_7094_());
                    }
                }
            }
        }
    }

    public float getSize() {
        return Math.max(((Float)this.f_19804_.m_135370_(SIZE)).floatValue(), 1.0f);
    }

    @VisibleForTesting
    public void setSize(float pSize) {
        float i = Mth.m_14036_((float)pSize, (float)1.0f, (float)127.0f);
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(i));
        this.m_20090_();
        this.m_6210_();
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (SIZE.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return super.m_6972_(pPose).m_20388_(this.getSize() * 0.5f);
    }
}

