/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.emiprofessions.emi;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.emiprofessions.Constants;
import com.mrbysco.emiprofessions.emi.ProfessionPlugin;
import com.mrbysco.emiprofessions.emi.ProfessionWrapper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.DrawableWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class ProfessionRecipe<T extends ProfessionWrapper>
implements EmiRecipe {
    private final ProfessionWrapper wrapper;

    public ProfessionRecipe(ProfessionWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public EmiRecipeCategory getCategory() {
        return ProfessionPlugin.PROFESSION;
    }

    @Nullable
    public ResourceLocation getId() {
        return Constants.modLoc("/" + this.wrapper.getProfessionName().m_135827_() + "/" + this.wrapper.getProfessionName().m_135815_());
    }

    public List<EmiIngredient> getInputs() {
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        for (ItemStack itemStack : this.wrapper.getBlockStacks()) {
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack});
            inputs.add(EmiIngredient.of((Ingredient)ingredient));
        }
        return inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of();
    }

    public int getDisplayWidth() {
        return 124;
    }

    public int getDisplayHeight() {
        return 62;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])this.wrapper.getBlockStacks().toArray(new ItemStack[0]))), 92, 22);
        widgets.addDrawable(22, 0, 72, 62, (DrawableWidget.DrawableWidgetConsumer)this.wrapper);
        widgets.addDrawable(0, 0, 124, 62, (DrawableWidget.DrawableWidgetConsumer)new DrawableProfessionName(this.wrapper));
    }

    private record DrawableProfessionName(ProfessionWrapper wrapper) implements DrawableWidget.DrawableWidgetConsumer
    {
        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
            String text = Screen.m_96638_() ? this.wrapper.getProfessionName().toString() : this.wrapper.getDisplayName().getString();
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(1.0f, 0.0f, 0.0f);
            Font font = Minecraft.m_91087_().f_91062_;
            if (font.m_92895_(text) > 122) {
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            }
            guiGraphics.m_280056_(font, text, 0, 0, 8, false);
            poseStack.m_85849_();
        }
    }
}

