/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.emiprofessions.emi;

import com.mrbysco.emiprofessions.Constants;
import com.mrbysco.emiprofessions.compat.CompatibilityHelper;
import com.mrbysco.emiprofessions.emi.ProfessionEntry;
import com.mrbysco.emiprofessions.emi.ProfessionRecipe;
import com.mrbysco.emiprofessions.emi.ProfessionWrapper;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

@EmiEntrypoint
public class ProfessionPlugin
implements EmiPlugin {
    private static final ResourceLocation UID = Constants.modLoc("emi_plugin");
    private static final EmiTexture PROFESSION_ICON = new EmiTexture(Constants.modLoc("textures/gui/profession_icon.png"), 0, 0, 16, 16);
    public static final EmiRecipeCategory PROFESSION = new EmiRecipeCategory(Constants.modLoc("professions"), (EmiRenderable)PROFESSION_ICON);

    public void register(EmiRegistry registry) {
        registry.addCategory(PROFESSION);
        registry.addWorkstation(PROFESSION, (EmiIngredient)EmiStack.of((ItemLike)Items.f_42616_));
        registry.addWorkstation(PROFESSION, (EmiIngredient)EmiStack.of((ItemLike)Items.f_42601_));
        this.registerRecipes(registry);
    }

    public void registerRecipes(EmiRegistry registration) {
        LinkedList<ProfessionWrapper> entries = new LinkedList<ProfessionWrapper>();
        List professions = BuiltInRegistries.f_256735_.m_123024_().toList();
        for (VillagerProfession profession : professions) {
            if (profession == VillagerProfession.f_35585_) continue;
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            LinkedList<ResourceLocation> knownItems = new LinkedList<ResourceLocation>();
            List types = BuiltInRegistries.f_256941_.m_123024_().toList();
            for (PoiType poiType : types) {
                Optional poiKey = BuiltInRegistries.f_256941_.m_7854_((Object)poiType);
                if (!poiKey.isPresent() || !profession.f_219629_().test(BuiltInRegistries.f_256941_.m_203636_((ResourceKey)poiKey.get()).orElse(null))) continue;
                for (BlockState state : poiType.f_27325_()) {
                    Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()));
                    if (block == null) continue;
                    ItemStack stack = CompatibilityHelper.compatibilityCheck(new ItemStack((ItemLike)block), BuiltInRegistries.f_256735_.m_7981_((Object)profession));
                    ResourceLocation location = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
                    if (stack.m_41619_() || knownItems.contains(location)) continue;
                    stacks.add(stack);
                    knownItems.add(location);
                }
            }
            if (stacks.isEmpty()) continue;
            entries.add(new ProfessionWrapper(new ProfessionEntry(profession, stacks)));
        }
        entries.forEach(entry -> registration.addRecipe(new ProfessionRecipe((ProfessionWrapper)entry)));
    }
}

