/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DoorBlock.class})
public class DoorBlockMixin
extends Block
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public DoorBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;Lnet/minecraft/world/level/block/state/properties/BlockSetType;)V"})
    private void enhanceConstructor(BlockBehaviour.Properties properties, BlockSetType blockset, CallbackInfo callback) {
        ((DoorBlock)this).m_49959_((BlockState)((DoorBlock)this).m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Inject(at={@At(value="TAIL")}, method={"createBlockStateDefinition(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V"})
    protected void injectBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo callback) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Inject(at={@At(value="HEAD")}, method={"getStateForPlacement(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;"}, cancellable=true)
    private void getStateForPlacement(BlockPlaceContext context, CallbackInfoReturnable<BlockState> callback) {
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        if (blockpos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockpos.m_7494_()).m_60629_(context) && ((DoorBlock)this).m_49966_().m_61138_((Property)WATERLOGGED)) {
            boolean flag = level.m_276867_(blockpos) || level.m_276867_(blockpos.m_7494_());
            callback.setReturnValue((Object)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((DoorBlock)this).m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)context.m_8125_())).m_61124_((Property)DoorBlock.f_52728_, (Comparable)((DoorBlock)this).m_52804_(context))).m_61124_((Property)DoorBlock.f_52729_, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"updateShape(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"})
    private void injectUpdateShape(BlockState stateIn, Direction direction, BlockState facingState, LevelAccessor accessor, BlockPos pos1, BlockPos pos2, CallbackInfoReturnable<BlockState> callback) {
        if (((Boolean)(stateIn = (BlockState)stateIn.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(accessor.m_6425_(pos1).m_76152_() == Fluids.f_76193_))).m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(pos1, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setPlacedBy(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V"}, cancellable=true)
    private void injectPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack, CallbackInfo callback) {
        if (!state.m_61138_((Property)WATERLOGGED)) {
            return;
        }
        level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76193_)), 3);
        callback.cancel();
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }
}

