/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnvehicles.vehicle.base;

import com.dragn0007.dragnvehicles.util.VVTags;
import com.dragn0007.dragnvehicles.vehicle.base.AbstractGeckolibVehicle;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractVehicle
extends AbstractGeckolibVehicle {
    protected static final EntityDataAccessor<Float> DATA_HEALTH = SynchedEntityData.m_135353_(AbstractVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> DATA_TYPE = SynchedEntityData.m_135353_(AbstractVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final Random RANDOM = new Random();
    protected static final double GRAVITY = 0.04;
    protected final double maxSpeed;
    protected final double acceleration;
    protected final float turnRate;
    protected final int maxHealth;
    protected double speed = 0.0;
    public UUID owner;
    private float targetRotation = 0.0f;
    private float currentRotation = 0.0f;
    private static final float MAX_TURN = 7.0f;
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNER = SynchedEntityData.m_135353_(AbstractVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(AbstractVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> LOCKED = SynchedEntityData.m_135353_(AbstractVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public AbstractVehicle(EntityType<? extends AbstractVehicle> type, Level level, double maxSpeed, double acceleration, float turnRate, int maxHealth, double wheelWidth, double wheelLength, Vec3[] riders) {
        super(type, level, wheelWidth, wheelLength, riders);
        this.maxSpeed = maxSpeed;
        this.acceleration = acceleration;
        this.turnRate = turnRate;
        this.maxHealth = maxHealth;
    }

    public float getFrontWheelRotation(float time) {
        return (this.currentRotation + (this.targetRotation - this.currentRotation) * time) * (float)Math.PI / 180.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleInput(Input input) {
        float forward = 0.0f;
        float turn = 0.0f;
        if (input.f_108570_) {
            turn = this.turnRate;
        }
        if (input.f_108571_) {
            turn = -this.turnRate;
        }
        if (forward != 0.0f && turn == 0.0f) {
            this.targetRotation = 0.0f;
        }
        this.currentRotation = this.targetRotation;
        if (Math.abs(this.targetRotation + turn) <= 7.0f) {
            this.targetRotation += turn;
        }
        float deg = this.currentRotation + this.m_146908_();
        float rad = deg * (float)Math.PI / 180.0f;
        if (forward != 0.0f && deg != this.m_146908_()) {
            this.m_146922_(deg);
        }
        this.m_20256_(this.m_20184_().m_82520_(-Math.sin(rad) * (double)forward, 0.0, Math.cos(rad) * (double)forward));
    }

    @Override
    public void m_8119_() {
        LivingEntity livingEntity;
        super.m_8119_();
        if (this.m_9236_().f_46443_ && (livingEntity = this.m_6688_()) instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)livingEntity;
            this.handleInput(player.f_108618_);
        }
    }

    @Override
    public void tickRidden() {
        this.handleSteering();
        this.handleAcceleration();
        Vec3 forward = this.m_20156_().m_82542_(1.0, 0.0, 1.0);
        Vec3 velocity = forward.m_82490_(this.speed);
        Vec3 move = this.m_20272_(velocity);
        move = move.m_82542_(1.0, 0.0, 1.0);
        if (!this.m_20068_()) {
            move = move.m_82520_(0.0, -0.04, 0.0);
        }
        this.m_20256_(move.m_82520_(0.0, this.m_20184_().f_82480_, 0.0));
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_146926_(this.rotlerp(this.m_146909_(), this.calculateTargetXRot(), 3.0f));
    }

    protected void handleAcceleration() {
        float forward = this.getForwardImpulse();
        double targetSpeed = (double)forward * this.maxSpeed;
        double diff = targetSpeed - this.speed;
        double accel = this.maxSpeed / (this.acceleration * 20.0);
        this.speed += (double)Mth.m_14205_((double)(forward == 0.0f ? diff : (double)forward)) * Math.min(Math.abs(accel), Math.abs(diff));
    }

    protected void handleSteering() {
        float f = (float)(this.speed / this.maxSpeed);
        float steer = -this.getLeftImpulse() * this.turnRate * f;
        if (steer == 0.0f) {
            return;
        }
        this.m_146922_(Mth.m_14177_((float)(this.m_146908_() + steer)));
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.m_6084_()) {
            return InteractionResult.PASS;
        }
        boolean isClientSide = this.m_9236_().f_46443_;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            if (isClientSide) {
                return InteractionResult.SUCCESS;
            }
            DyeItem dyeitem = (DyeItem)item;
            DyeColor dyecolor = dyeitem.m_41089_();
            if (dyecolor != this.getColor()) {
                this.setColor(dyecolor);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (player.m_36341_()) {
            if (this.tryMountMob(player)) {
                return InteractionResult.m_19078_((boolean)isClientSide);
            }
            if (stack.m_150930_(Items.f_42655_)) {
                if (isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                for (Entity passenger : this.m_20197_()) {
                    if (!(passenger instanceof Mob)) continue;
                    Mob mob = (Mob)passenger;
                    mob.m_8127_();
                    player.m_21120_(hand).m_41774_(1);
                    if (!mob.m_6573_(player)) break;
                    mob.m_21463_((Entity)player, true);
                    break;
                }
                return InteractionResult.CONSUME;
            }
        }
        if (player.m_20202_() != this) {
            if (!this.m_9236_().f_46443_) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.m_19078_((!this.m_9236_().f_46443_ ? 1 : 0) != 0);
        }
        return super.m_6096_(player, hand);
    }

    protected boolean tryMountMob(Player player) {
        Mob mob = this.m_9236_().m_6443_(Mob.class, new AABB(player.m_20185_() - 7.0, player.m_20186_() - 7.0, player.m_20189_() - 7.0, player.m_20185_() + 7.0, player.m_20186_() + 7.0, player.m_20189_() + 7.0), h -> h.m_21524_() == player && !h.m_6095_().m_204039_(VVTags.Entity_Types.CANNOT_RIDE_VEHICLE)).stream().findFirst().orElse(null);
        if (mob != null && !this.m_9236_().f_46443_ && this.m_7310_((Entity)mob)) {
            mob.m_20329_((Entity)this);
        }
        return mob != null;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        double width = this.m_20205_();
        double offset = Math.sqrt(width * width + width * width) / 2.0 + 0.05;
        double pWidth = passenger.m_20205_();
        double pOffset = Math.sqrt(pWidth * pWidth + pWidth * pWidth) / 2.0;
        float yRot = this.m_146908_();
        Vec3 wOffset = new Vec3(0.0, (double)passenger.m_20192_(), 0.0);
        Vec3 pos = this.m_20182_().m_82549_(this.rotateY(new Vec3(offset + pOffset, 0.0, 0.0), yRot));
        if (this.isEmpty(AABB.m_165882_((Vec3)pos.m_82549_(wOffset), (double)(pWidth *= (double)0.8f), (double)1.0E-6, (double)pWidth))) {
            return pos;
        }
        pos = this.m_20182_().m_82549_(this.rotateY(new Vec3(-offset - pOffset, 0.0, 0.0), yRot));
        if (this.isEmpty(AABB.m_165882_((Vec3)pos.m_82549_(wOffset), (double)pWidth, (double)1.0E-6, (double)pWidth))) {
            return pos;
        }
        pos = this.m_20182_().m_82549_(this.rotateY(new Vec3(0.0, 0.0, offset + pOffset), yRot));
        if (this.isEmpty(AABB.m_165882_((Vec3)pos.m_82549_(wOffset), (double)pWidth, (double)1.0E-6, (double)pWidth))) {
            return pos;
        }
        pos = this.m_20182_().m_82549_(this.rotateY(new Vec3(0.0, 0.0, -offset - pOffset), yRot));
        if (this.isEmpty(AABB.m_165882_((Vec3)pos.m_82549_(wOffset), (double)pWidth, (double)1.0E-6, (double)pWidth))) {
            return pos;
        }
        return super.m_7688_(passenger);
    }

    public boolean isEmpty(AABB aabb) {
        return BlockPos.m_121921_((AABB)aabb).noneMatch(pos -> {
            BlockState state = this.m_9236_().m_8055_(pos);
            return !state.m_60795_() && state.m_60828_((BlockGetter)this.m_9236_(), pos) && Shapes.m_83157_((VoxelShape)state.m_60812_((BlockGetter)this.m_9236_(), pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            this.m_9236_().m_247517_(null, this.m_20183_(), SoundEvents.f_12630_, SoundSource.MASTER);
            double w = this.m_20205_();
            double h = this.m_20206_();
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50741_.m_49966_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 100, w, h, w, 0.0);
            this.setHealth(this.getHealth() - amount);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, source.m_7639_());
            Entity entity = source.m_7639_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (this.getOwner().equals(player.m_20148_())) {
                    if (this.getHealth() <= 0.0f) {
                        this.onDestroyed(true);
                    }
                } else if (this.getHealth() <= 0.0f) {
                    this.onDestroyed(false);
                }
            }
            return true;
        }
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        return true;
    }

    protected void onDestroyed(boolean dropItem) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.m_20153_();
        this.m_146870_();
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            return;
        }
        if (dropItem) {
            ItemStack pickResult = this.m_142340_();
            if (pickResult != null) {
                this.m_19983_(pickResult);
            }
        } else {
            this.m_19983_(new ItemStack((ItemLike)Items.f_42416_, RANDOM.nextInt(10)));
            this.m_19983_(new ItemStack((ItemLike)Items.f_41904_, RANDOM.nextInt(3)));
        }
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID pUuid) {
        this.owner = pUuid;
    }

    public DyeColor getColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLOR)));
    }

    public void setColor(DyeColor p_30398_) {
        this.f_19804_.m_135381_(DATA_COLOR, (Object)p_30398_.m_41060_());
    }

    public boolean isLocked() {
        return (Boolean)this.f_19804_.m_135370_(LOCKED);
    }

    public void setLocked(boolean locked) {
        this.f_19804_.m_135381_(LOCKED, (Object)locked);
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.getOwner() != null) {
            tag.m_128362_("owner", this.getOwner());
        }
        ListTag animals = new ListTag();
        tag.m_128365_("animals", (Tag)animals);
        tag.m_128344_("color", (byte)this.getColor().m_41060_());
        tag.m_128379_("locked", this.isLocked());
    }

    protected void m_7378_(CompoundTag tag) {
        UUID uuid;
        if (tag.m_128425_("color", 99)) {
            this.setColor(DyeColor.m_41053_((int)tag.m_128451_("color")));
        }
        if (tag.m_128403_("owner")) {
            uuid = tag.m_128342_("owner");
        } else {
            String s = tag.m_128461_("owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            this.setOwner(uuid);
        }
        if (tag.m_128441_("locked")) {
            this.setLocked(tag.m_128471_("locked"));
        }
    }

    public float getHealth() {
        return ((Float)this.f_19804_.m_135370_(DATA_HEALTH)).floatValue();
    }

    protected void setHealth(float health) {
        this.f_19804_.m_135381_(DATA_HEALTH, (Object)Float.valueOf(Mth.m_14036_((float)health, (float)0.0f, (float)this.maxHealth)));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TYPE, (Object)0);
        this.f_19804_.m_135372_(DATA_HEALTH, (Object)Float.valueOf(this.maxHealth));
        this.f_19804_.m_135372_(DATA_COLOR, (Object)DyeColor.WHITE.m_41060_());
        this.f_19804_.m_135372_(DATA_OWNER, Optional.empty());
        this.f_19804_.m_135372_(LOCKED, (Object)false);
    }

    public boolean m_6109_() {
        return this.m_21515_();
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return !this.m_6095_().m_204039_(EntityTypeTags.f_273841_);
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }
}

