/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnvehicles.vehicle.base;

import com.dragn0007.dragnvehicles.vehicle.base.AbstractVehicle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInventoryVehicle
extends AbstractVehicle
implements ContainerListener {
    public SimpleContainer inventory;
    protected LazyOptional<?> itemHandler;

    public AbstractInventoryVehicle(EntityType<? extends AbstractVehicle> type, Level level, double maxSpeed, double acceleration, float turnRate, int maxHealth, double wheelWidth, double wheelLength, Vec3[] riders) {
        super(type, level, maxSpeed, acceleration, turnRate, maxHealth, wheelWidth, wheelLength, riders);
        this.createInventory();
    }

    protected void createInventory() {
        this.inventory = new SimpleContainer(0);
        this.inventory.m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_6144_() && !this.m_9236_().f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((containerId, inventory, serverPlayer) -> ChestMenu.m_39237_((int)containerId, (Inventory)inventory, (Container)this.inventory), this.m_5446_()));
        }
        return super.m_6096_(player, hand);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.m_6084_() && cap == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_()) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.createInventory();
        ListTag listTag = compoundTag.m_128437_("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag tag = listTag.m_128728_(i);
            int j = tag.m_128445_("Slot") & 0xFF;
            if (j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)tag));
        }
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemStack = this.inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("Slot", (byte)i);
            itemStack.m_41739_(tag);
            listTag.add((Object)tag);
        }
        compoundTag.m_128365_("Items", (Tag)listTag);
    }

    @Override
    protected void onDestroyed(boolean dropItem) {
        super.onDestroyed(dropItem);
        if (!this.m_9236_().f_46443_) {
            Containers.m_19002_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (Container)this.inventory);
        }
    }
}

