/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnvehicles.vehicle;

import com.dragn0007.dragnvehicles.item.VVItems;
import com.dragn0007.dragnvehicles.util.ValiantVehiclesCommonConfig;
import com.dragn0007.dragnvehicles.vehicle.base.AbstractInventoryVehicle;
import com.dragn0007.dragnvehicles.vehicle.base.AbstractVehicle;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class Motorcycle
extends AbstractInventoryVehicle
implements ContainerListener {
    public static final Vec3[] RIDERS = new Vec3[]{new Vec3(0.0, 1.15, -0.1), new Vec3(0.0, 1.15, -0.6)};

    public Motorcycle(EntityType<? extends AbstractVehicle> type, Level level) {
        super(type, level, (Double)ValiantVehiclesCommonConfig.MOTORCYCLE_SPEED_MULT.get(), (Double)ValiantVehiclesCommonConfig.MOTORCYCLE_SPEED_ACC.get(), ((Float)ValiantVehiclesCommonConfig.MOTORCYCLE_SPEED_TURN.get()).floatValue(), (Integer)ValiantVehiclesCommonConfig.MOTORCYCLE_HEALTH.get(), 1.25, 1.25, RIDERS);
        this.createInventory();
    }

    public ItemStack m_142340_() {
        return ((Item)VVItems.MOTORCYCLE_SPAWN_EGG.get()).m_7968_();
    }

    @Override
    protected void createInventory() {
        this.inventory = new SimpleContainer(9);
        this.inventory.m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (player.m_6144_() && !(item instanceof DyeItem) && item != VVItems.CAR_KEY.get() && !this.m_9236_().f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((containerId, inventory, serverPlayer) -> ChestMenu.m_39234_((int)containerId, (Inventory)inventory), this.m_5446_()));
        }
        return super.m_6096_(player, hand);
    }

    public void m_5757_(Container container) {
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.createInventory();
        ListTag listTag = compoundTag.m_128437_("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag tag = listTag.m_128728_(i);
            int j = tag.m_128445_("Slot") & 0xFF;
            if (j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)tag));
        }
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemStack = this.inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("Slot", (byte)i);
            itemStack.m_41739_(tag);
            listTag.add((Object)tag);
        }
        compoundTag.m_128365_("Items", (Tag)listTag);
    }
}

