/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.equipment;

import com.brandon3055.brandonscore.capability.MultiCapabilityProvider;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.CurioWrapper;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.lib.WTFException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CuriosIntegration
extends EquipmentManager {
    public static final TagKey<Item> CURIO_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("curios", "curio"));
    public static final TagKey<Item> BODY_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("curios", "body"));
    public static Capability<ICurio> CURIO_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<ICurio>(){});

    public static void sendIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CURIO.getMessageBuilder().size(2).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BODY.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    public void addEquipCaps(ItemStack stack, MultiCapabilityProvider provider) {
        provider.addUnsavedCap(CURIO_CAP, (Object)new CurioWrapper(stack));
    }

    public LazyOptional<IItemHandlerModifiable> getInventory(LivingEntity entity) {
        return CuriosApi.getCuriosHelper().getEquippedCurios(entity);
    }

    public ItemStack findMatchingItem(Item item, LivingEntity entity) {
        return CuriosApi.getCuriosHelper().findFirstCurio(entity, item).map(SlotResult::stack).orElse(ItemStack.f_41583_);
    }

    public ItemStack findMatchingItem(Predicate<ItemStack> predicate, LivingEntity entity) {
        return CuriosApi.getCuriosHelper().findFirstCurio(entity, predicate).map(SlotResult::stack).orElse(ItemStack.f_41583_);
    }

    public List<ResourceLocation> getSlotIcons(LivingEntity entity) {
        LazyOptional optional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (optional.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)optional.orElseThrow(WTFException::new);
            ArrayList<ResourceLocation> icons = new ArrayList<ResourceLocation>();
            handler.getCurios().forEach((s, h) -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    ResourceLocation icon = CuriosApi.getSlotIcon((String)s);
                    icons.add(new ResourceLocation(icon.m_135827_(), "textures/" + icon.m_135815_() + ".png"));
                }
            });
            return icons;
        }
        return Collections.emptyList();
    }

    public static void generateTags(Function<TagKey<Item>, TagsProvider.TagAppender> builder) {
        builder.apply(CURIO_TAG).m_211101_(new ResourceKey[]{DEContent.DISLOCATOR_ADVANCED.getKey(), DEContent.MAGNET.getKey(), DEContent.MAGNET_ADVANCED.getKey(), DEContent.CAPACITOR_WYVERN.getKey(), DEContent.CAPACITOR_DRACONIC.getKey(), DEContent.CAPACITOR_CHAOTIC.getKey(), DEContent.CAPACITOR_CREATIVE.getKey()});
        builder.apply(BODY_TAG).m_211101_(new ResourceKey[]{DEContent.CHESTPIECE_WYVERN.getKey(), DEContent.CHESTPIECE_DRACONIC.getKey(), DEContent.CHESTPIECE_CHAOTIC.getKey()});
    }
}

