/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.sound;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGenerator;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.lib.ISidedTileHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class GeneratorSoundHandler
implements ISidedTileHandler {
    private TileGenerator tile;
    private GeneratorSound activeSound = null;
    private boolean currentHigh = false;
    private boolean startHigh = false;

    public GeneratorSoundHandler(TileGenerator tile) {
        this.tile = tile;
    }

    @Override
    public void tick() {
        if (!this.tile.active.get()) {
            if (this.activeSound != null) {
                this.activeSound.fadeDown = true;
                if (this.activeSound.m_7801_()) {
                    this.activeSound = null;
                }
            }
            return;
        }
        TileGenerator.Mode mode = (TileGenerator.Mode)this.tile.mode.get();
        if (this.activeSound == null || this.activeSound.m_7801_()) {
            if (mode.index >= 2) {
                this.activeSound = new GeneratorSound(this.tile, (SoundEvent)DESounds.GENERATOR2.get(), this.startHigh ? 1.5f : 0.5f);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.activeSound);
                this.currentHigh = true;
            } else {
                this.activeSound = new GeneratorSound(this.tile, (SoundEvent)DESounds.GENERATOR1.get(), this.startHigh ? 1.0f : 0.5f);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.activeSound);
                this.currentHigh = false;
            }
        }
        if (mode.index >= 2) {
            if (!this.currentHigh) {
                this.activeSound.fadeUp = true;
                this.startHigh = false;
            } else {
                this.activeSound.targetPitch = mode == TileGenerator.Mode.NORMAL ? 0.6f : (mode == TileGenerator.Mode.PERFORMANCE ? 1.3f : 1.6f);
            }
        } else if (this.currentHigh) {
            this.activeSound.fadeDown = true;
            this.startHigh = true;
        } else {
            this.activeSound.targetPitch = mode == TileGenerator.Mode.ECO_PLUS ? 0.5f : 0.7f;
        }
    }

    public class GeneratorSound
    extends SimpleSoundInstance
    implements TickableSoundInstance {
        public boolean donePlaying;
        private TileGenerator tile;
        private float targetPitch;
        boolean fadeUp;
        boolean fadeDown;

        public GeneratorSound(TileGenerator tile, SoundEvent sound, float startPitch) {
            super(sound, SoundSource.BLOCKS, 0.3f, 1.0f, tile.m_58904_().f_46441_, tile.m_58899_());
            this.donePlaying = false;
            this.fadeUp = false;
            this.fadeDown = false;
            this.tile = tile;
            this.f_119578_ = true;
            this.f_119574_ = startPitch;
            this.targetPitch = startPitch;
        }

        public boolean m_7801_() {
            return this.donePlaying;
        }

        public void m_7788_() {
            this.f_119575_ = (float)this.tile.m_58899_().m_123341_() + 0.5f;
            this.f_119576_ = (float)this.tile.m_58899_().m_123342_() + 0.5f;
            this.f_119577_ = (float)this.tile.m_58899_().m_123343_() + 0.5f;
            if (this.fadeUp) {
                this.targetPitch = 1.5f;
            } else if (this.fadeDown) {
                this.targetPitch = 0.5f;
            }
            if (this.fadeUp && this.f_119574_ >= 1.0f || this.fadeDown && (double)this.f_119574_ <= 0.55 || this.tile.m_58901_()) {
                this.donePlaying = true;
                this.f_119578_ = false;
            }
            this.f_119574_ = (float)MathHelper.approachExp((double)this.f_119574_, (double)this.targetPitch, (double)0.05);
        }
    }
}

