/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.AtlasTextureHelper;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class CrystalFXRing
extends CrystalFXBase<TileCrystalBase> {
    private long rSeed = 0L;
    public static final ParticleRenderType RENDER_TYPE = new ParticleRenderType(){

        public void m_6505_(BufferBuilder builder, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShader(GameRenderer::m_172835_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
        }

        public void m_6294_(Tesselator tessellator) {
            tessellator.m_85915_().m_277127_(VertexSorting.m_277071_((float)0.0f, (float)0.0f, (float)0.0f));
            tessellator.m_85914_();
        }
    };

    public CrystalFXRing(ClientLevel worldIn, TileCrystalBase tile) {
        super(worldIn, tile);
        this.f_107224_ = worldIn.f_46441_.m_188503_(1024);
        this.rSeed = tile.m_58899_().m_121878_();
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        if (this.ticksTillDeath-- <= 0) {
            this.m_107274_();
        }
        float[] r = new float[]{0.0f, 0.8f, 1.0f};
        float[] g = new float[]{0.8f, 0.1f, 0.7f};
        float[] b = new float[]{1.0f, 1.0f, 0.2f};
        this.f_107227_ = r[((TileCrystalBase)this.tile).getTier()];
        this.f_107228_ = g[((TileCrystalBase)this.tile).getTier()];
        this.f_107229_ = b[((TileCrystalBase)this.tile).getTier()];
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        if (!this.renderEnabled || AtlasTextureHelper.ENERGY_PARTICLE == null || AtlasTextureHelper.ENERGY_PARTICLE[0] == null) {
            return;
        }
        boolean wierless = ((TileCrystalBase)this.tile).getCrystalType() == EnergyCrystal.CrystalType.WIRELESS;
        this.f_107223_.m_188584_(this.rSeed);
        float animTime = (float)(ClientEventHandler.elapsedTicks + this.f_107224_) + partialTicks;
        Vec3 view = camera.m_90583_();
        float viewX = (float)(this.f_107212_ - view.m_7096_());
        float viewY = (float)(this.f_107213_ - view.m_7098_());
        float viewZ = (float)(this.f_107214_ - view.m_7094_());
        double mipLevel = Math.max(0.0, Math.min(1.0, (camera.m_90588_().m_203198_(this.f_107212_, this.f_107213_, this.f_107214_) - 20.0) / 600.0));
        double pCount = 20.0 + 80.0 * (1.0 - mipLevel);
        int i = 0;
        while ((double)i < pCount) {
            double rotation = (double)i / pCount * 6.282 + (double)animTime / 80.0;
            float rFloat3 = this.f_107223_.m_188501_();
            float rFloat4 = this.f_107223_.m_188501_();
            float scale = 0.01f + rFloat4 * 0.05f + (float)mipLevel * 0.2f;
            float a = 1.0f;
            float r = this.f_107227_;
            float g = this.f_107228_;
            float b = this.f_107229_;
            double subRotationRadius = 0.1 * (double)rFloat3 + 0.02;
            double dir = this.f_107223_.m_188499_() ? 1.0 : -1.0;
            double sy = Math.cos(dir * (rotation -= (double)0.05f) * (double)(rFloat3 * 10.0f) * (double)(1.0f - this.f_107223_.m_188501_() * 0.2f)) * subRotationRadius;
            double sx = Math.sin(dir * rotation * (double)(rFloat3 * 10.0f) * (double)(1.0f - this.f_107223_.m_188501_() * 0.2f)) * subRotationRadius;
            float drawY = viewY + (float)sy;
            double renderRadius = 0.4 + sx;
            double ox = Math.sin(rotation) * renderRadius;
            double oz = Math.cos(rotation) * renderRadius;
            float drawX = viewX + (float)ox;
            float drawZ = viewZ + (float)oz;
            int texIndex = ClientEventHandler.elapsedTicks % AtlasTextureHelper.ENERGY_PARTICLE.length;
            TextureAtlasSprite sprite = AtlasTextureHelper.ENERGY_PARTICLE[texIndex];
            float minU = sprite.m_118409_();
            float maxU = sprite.m_118410_();
            float minV = sprite.m_118411_();
            float maxV = sprite.m_118412_();
            Vector3f[] renderVector = this.getRenderVectors(camera, drawX, drawY, drawZ, scale);
            buffer.m_5483_((double)renderVector[0].x(), (double)renderVector[0].y(), (double)renderVector[0].z()).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[1].x(), (double)renderVector[1].y(), (double)renderVector[1].z()).m_85950_(r, g, b, a).m_7421_(maxU, minV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[2].x(), (double)renderVector[2].y(), (double)renderVector[2].z()).m_85950_(r, g, b, a).m_7421_(minU, minV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[3].x(), (double)renderVector[3].y(), (double)renderVector[3].z()).m_85950_(r, g, b, a).m_7421_(minU, maxV).m_7120_(240, 240).m_5752_();
            scale = 0.01f + rFloat4 * 0.04f * (float)Math.sin((animTime + (float)i) / 30.0f) + (float)mipLevel * 0.05f;
            rotation = (double)i / pCount * 6.282 + (double)animTime / 200.0;
            renderRadius = 0.4;
            ox = Math.sin(rotation -= (double)0.05f) * renderRadius;
            oz = Math.cos(rotation) * renderRadius;
            drawX = viewX + (float)ox;
            drawY = viewY;
            drawZ = viewZ + (float)oz;
            r = wierless ? 1.0f : 0.0f;
            g = wierless ? 0.0f : 1.0f;
            b = wierless ? 0.0f : 1.0f;
            minU = AtlasTextureHelper.ORB_PARTICLE.m_118409_();
            maxU = AtlasTextureHelper.ORB_PARTICLE.m_118410_();
            minV = AtlasTextureHelper.ORB_PARTICLE.m_118411_();
            maxV = AtlasTextureHelper.ORB_PARTICLE.m_118412_();
            renderVector = this.getRenderVectors(camera, drawX, drawY, drawZ, scale);
            buffer.m_5483_((double)renderVector[0].x(), (double)renderVector[0].y(), (double)renderVector[0].z()).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[1].x(), (double)renderVector[1].y(), (double)renderVector[1].z()).m_85950_(r, g, b, a).m_7421_(maxU, minV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[2].x(), (double)renderVector[2].y(), (double)renderVector[2].z()).m_85950_(r, g, b, a).m_7421_(minU, minV).m_7120_(240, 240).m_5752_();
            buffer.m_5483_((double)renderVector[3].x(), (double)renderVector[3].y(), (double)renderVector[3].z()).m_85950_(r, g, b, a).m_7421_(minU, maxV).m_7120_(240, 240).m_5752_();
            ++i;
        }
    }

    public ParticleRenderType m_7556_() {
        return RENDER_TYPE;
    }
}

