/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular;

import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiItemStack;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.geometry.Align;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleRegistry;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SupportedModulesIcon
extends GuiElement<SupportedModulesIcon> {
    private Map<ModuleType<?>, List<Module<?>>> supported = new HashMap();
    private Map<Module<?>, ItemStack> moduleStacks = new HashMap();
    private GuiItemStack cyclingIcon;
    private GuiElement<?> hoverElement;
    private boolean locked = false;
    private int page = Integer.MIN_VALUE;
    private int pages = 0;
    private double xPos = 0.0;
    private double yPos = 0.0;

    public SupportedModulesIcon(GuiParent<?> parent, ModuleHost host) {
        super(parent);
        for (Module module : ModuleRegistry.getRegistry().getValues()) {
            if (host.getHostTechLevel().index < module.getModuleTechLevel().index || !host.isModuleSupported(module.createEntity())) continue;
            this.supported.computeIfAbsent(module.getType(), e -> new ArrayList()).add(module);
            this.moduleStacks.put(module, new ItemStack((ItemLike)module.getItem()));
        }
        this.addElements();
    }

    public void addElements() {
        this.cyclingIcon = new GuiItemStack((GuiParent)this).enableStackToolTip(false).setStack(() -> this.supported.isEmpty() ? ItemStack.f_41583_ : (ItemStack)ImmutableList.copyOf(this.moduleStacks.values()).get(TimeKeeper.interval((int)20, (int)this.moduleStacks.values().size())));
        Constraints.bind((ConstrainedGeometry)this.cyclingIcon, (ConstrainedGeometry)this);
        GuiRectangle hoverBackground = (GuiRectangle)((GuiRectangle)((GuiRectangle)GuiRectangle.toolTipBackground((GuiParent)this).setOpaque(true)).jeiExclude()).setEnabled(() -> this.cyclingIcon.isMouseOver() || this.locked);
        GuiText title = (GuiText)((GuiText)new GuiText((GuiParent)hoverBackground, (Component)Component.m_237115_((String)"gui.draconicevolution.modular_item.supported_modules").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.UNDERLINE)).setAlignment(Align.LEFT).setScroll(false).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)12.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        Constraints.placeInside((ConstrainedGeometry)title, (ConstrainedGeometry)hoverBackground, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)4.0, (double)3.0);
        GuiButton right = GuiButton.flatColourButton((GuiParent)hoverBackground, () -> Component.m_237113_((String)">"), e -> e != false ? 0x60909090 : 0).onPress(() -> this.cyclePage(1));
        right.getLabel().setScroll(false);
        Constraints.size((ConstrainedGeometry)right, (double)8.0, (double)8.0);
        Constraints.placeInside((ConstrainedGeometry)right, (ConstrainedGeometry)hoverBackground, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)-3.0, (double)3.0);
        GuiButton left = GuiButton.flatColourButton((GuiParent)hoverBackground, () -> Component.m_237113_((String)"<"), e -> e != false ? 0x60909090 : 0).onPress(() -> this.cyclePage(-1));
        left.getLabel().setScroll(false);
        Constraints.size((ConstrainedGeometry)left, (double)8.0, (double)8.0);
        Constraints.placeInside((ConstrainedGeometry)left, (ConstrainedGeometry)hoverBackground, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)-13.0, (double)3.0);
        int itemOffset = 14;
        int iconSize = 18;
        ArrayList<GuiElement> displayElements = new ArrayList<GuiElement>();
        int index = 0;
        int buildPage = 0;
        for (ModuleType<?> type : this.supported.keySet()) {
            List<Module<?>> modules = this.supported.get(type);
            for (Module<?> module : modules) {
                if (index == 0) {
                    ++this.pages;
                }
                ItemStack stack = this.moduleStacks.get(module);
                int containerWidth = Math.max(this.minWidth(stack.m_41611_()), 120) + iconSize + 2;
                int finalBuildPage = buildPage++;
                GuiElement container = (GuiElement)((GuiElement)((GuiElement)((GuiElement)new GuiElement((GuiParent)hoverBackground).setEnabled(() -> this.getPage() == finalBuildPage).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)hoverBackground.get(GeoParam.TOP), (double)((double)itemOffset + (double)index * ((double)iconSize + 1.0))))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)hoverBackground.get(GeoParam.LEFT), (double)3.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)containerWidth))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)iconSize));
                GuiItemStack icon = new GuiItemStack((GuiParent)container).setStack(() -> stack);
                Constraints.size((ConstrainedGeometry)icon, (double)iconSize, (double)iconSize);
                Constraints.placeInside((ConstrainedGeometry)icon, (ConstrainedGeometry)container, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT);
                GuiText label = ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)container).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)icon.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)icon.get(GeoParam.TOP)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)container.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)iconSize))).setWrap(true).setAlignment(Align.LEFT).setTextSupplier(() -> stack.m_41786_().m_6881_().m_130938_(stack.m_41791_().getStyleModifier()));
                displayElements.add(container);
                if (++index != 8) continue;
                index = 0;
            }
        }
        hoverBackground.constrain(GeoParam.TOP, (Constraint)Constraint.dynamic(() -> this.yPos));
        hoverBackground.constrain(GeoParam.RIGHT, (Constraint)Constraint.dynamic(() -> this.xPos));
        hoverBackground.constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> displayElements.stream().filter(GuiElement::isEnabled).mapToDouble(ConstrainedGeometry::xSize).max().orElse(10.0) + 6.0));
        hoverBackground.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> displayElements.stream().filter(GuiElement::isEnabled).mapToDouble(ConstrainedGeometry::ySize).sum() + (double)itemOffset + 10.0));
    }

    private int minWidth(Component component) {
        int w = this.font().m_92852_((FormattedText)component) / 2;
        while (this.font().m_92865_().m_92414_((FormattedText)component, w, component.m_7383_()).size() > 2) {
            ++w;
        }
        return w;
    }

    private int getPage() {
        return this.page == Integer.MIN_VALUE ? TimeKeeper.getClientTick() / 60 % this.pages : this.page;
    }

    private void cyclePage(int dir) {
        this.page += dir;
        if (this.page < 0) {
            this.page = this.pages - 1;
        }
        if (this.page == this.pages) {
            this.page = 0;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver() && !this.locked) {
            this.locked = true;
            this.mc().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        } else if (this.locked) {
            this.locked = false;
            this.page = Integer.MIN_VALUE;
            this.mc().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void tick(double mouseX, double mouseY) {
        if (!this.locked) {
            this.xPos = mouseX;
            this.yPos = mouseY;
        }
        super.tick(mouseX, mouseY);
    }
}

