/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostContainer;
import com.brandon3055.draconicevolution.client.gui.ModuleGridRenderer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class ModuleGridPanel
extends GuiElement<ModuleGridPanel>
implements BackgroundRender {
    private static AtomicBoolean globalExpanded = new AtomicBoolean(false);
    private final int colour;
    private double animState = 0.0;
    public int fixedGridSize = -1;
    private ModuleGrid grid;
    private AtomicBoolean expanded = globalExpanded;
    public ModuleGridRenderer gridRenderer;

    public ModuleGridPanel(@NotNull GuiParent<?> parent, ModuleHostContainer container) {
        super(parent);
        this.jeiExclude();
        this.grid = container.getGrid();
        TechLevel techLevel = container.getModuleHost().getHostTechLevel();
        this.colour = techLevel.getTextColour().m_126664_() ? techLevel.getTextColour().m_126665_() : 33023;
        this.gridRenderer = (ModuleGridRenderer)new ModuleGridRenderer((GuiParent<?>)this, this.grid, this.mc().f_91074_.m_150109_()).setEnabled(() -> this.expanded.get() && this.animState >= 1.0);
        this.gridRenderer.renderBorder = false;
        Constraints.center((ConstrainedGeometry)this.gridRenderer, (ConstrainedGeometry)this);
        this.constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> ((double)(this.computeGridSize() * this.grid.getWidth()) + 6.0) * Math.max(0.0, this.animState)));
        this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> ((double)(this.computeGridSize() * this.grid.getHeight()) + 6.0) * Math.max(0.0, this.animState)));
    }

    public ModuleGridPanel setGridPos(GridPos pos, int offset) {
        ((ModuleGridPanel)((ModuleGridPanel)((ModuleGridPanel)this.constrain(GeoParam.TOP, null)).constrain(GeoParam.LEFT, null)).constrain(GeoParam.BOTTOM, null)).constrain(GeoParam.RIGHT, null);
        GuiElement root = this.getModularGui().getRoot();
        return switch (pos) {
            default -> throw new IncompatibleClassChangeError();
            case GridPos.TOP_RIGHT -> (ModuleGridPanel)((ModuleGridPanel)this.constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)offset));
            case GridPos.BOTTOM_RIGHT -> (ModuleGridPanel)((ModuleGridPanel)this.constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)offset));
            case GridPos.TOP_LEFT -> (ModuleGridPanel)((ModuleGridPanel)this.constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.TOP)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)offset));
            case GridPos.BOTTOM_LEFT -> (ModuleGridPanel)((ModuleGridPanel)this.constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)offset));
        };
    }

    private int computeGridSize() {
        if (this.fixedGridSize > 0) {
            return this.fixedGridSize;
        }
        GuiElement root = this.getModularGui().getRoot();
        int swidth = this.scaledScreenWidth();
        double space = root.xMin() < (double)swidth / 2.0 && root.xMax() < (double)swidth / 2.0 ? root.xMin() : (double)this.scaledScreenWidth() - root.xMax();
        double maxWidth = Math.min((double)(this.grid.getWidth() * 16), space - 8.0);
        return (int)(maxWidth / (double)this.grid.getWidth());
    }

    public void toggleExpanded() {
        this.expanded.set(!this.expanded.get());
    }

    public ModuleGridPanel setExpandedStateHolder(AtomicBoolean expanded) {
        this.expanded = expanded;
        return this;
    }

    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
        if (this.grid.getCellSize() != this.computeGridSize()) {
            this.grid.setCellSize(this.computeGridSize());
        }
        if (this.expanded.get() && this.animState < 1.0) {
            this.animState = Math.min(1.0, this.animState + 0.2);
        } else if (!this.expanded.get() && this.animState > 0.0) {
            this.animState = Math.max(0.0, this.animState - 0.2);
        }
    }

    public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        double fadeAlpha = MathHelper.clip((double)((this.animState - 0.1) * 1.1), (double)0.0, (double)1.0);
        int backgroundCol = 0x100010 | (int)(240.0 * fadeAlpha) << 24;
        int borderCol = this.colour | (int)(176.0 * fadeAlpha) << 24;
        int borderColorEnd = (borderCol & 0xFEFEFE) >> 1 | borderCol & 0xFF000000;
        render.toolTipBackground(this.xMin(), this.yMin(), this.xSize(), this.ySize(), backgroundCol, borderCol, borderColorEnd);
    }

    public static enum GridPos {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;

    }
}

