/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.lib.datamanager.ManagedResource;
import com.brandon3055.draconicevolution.blocks.StructureBlock;
import com.brandon3055.draconicevolution.blocks.tileentity.MultiBlockController;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TileStructureBlock
extends TileBCore
implements IInteractTile {
    public final ManagedPos controllerOffset = (ManagedPos)this.register((IManagedData)new ManagedPos("controller_offset", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.SYNC_ON_SET}));
    public final ManagedResource blockName = (ManagedResource)this.register((IManagedData)new ManagedResource("block_name", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.SYNC_ON_SET}));
    public final ManagedBool reverting = (ManagedBool)this.register((IManagedData)new ManagedBool("reverting", new DataFlags[]{DataFlags.SAVE_NBT}));

    public TileStructureBlock(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_STRUCTURE_BLOCK.get(), pos, state);
        this.enableTileDebug();
    }

    public void setController(MultiBlockController controller) {
        this.controllerOffset.set(this.f_58858_.m_121996_((Vec3i)((BlockEntity)controller).m_58899_()));
    }

    public void tick() {
        super.tick();
    }

    @Nullable
    private BlockPos getControllerPos() {
        return this.controllerOffset.get() == null ? null : this.f_58858_.m_121996_((Vec3i)Objects.requireNonNull(this.controllerOffset.get()));
    }

    @Nullable
    public MultiBlockController getController() {
        BlockEntity tile;
        BlockPos pos = this.getControllerPos();
        if (pos != null && (tile = this.f_58857_.m_7702_(pos)) instanceof MultiBlockController) {
            return (MultiBlockController)tile;
        }
        this.debug("Structure Block: Reverting because controller not found");
        this.revert();
        return null;
    }

    public Block getOriginalBlock() {
        ResourceLocation name = this.blockName.get();
        if (name != null) {
            return (Block)ForgeRegistries.BLOCKS.getValue(name);
        }
        return Blocks.f_50016_;
    }

    public void revert() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        StructureBlock.buildingLock = true;
        this.f_58857_.m_186460_(this.f_58858_, (Block)DEContent.STRUCTURE_BLOCK.get(), 1);
        this.reverting.set(true);
        StructureBlock.buildingLock = false;
    }

    public void doRevert() {
        if (this.reverting.get()) {
            this.debug("Tile Structure Block: doRevert");
            Block block = this.getOriginalBlock();
            if (block != null && block != Blocks.f_50016_) {
                this.f_58857_.m_46597_(this.f_58858_, block.m_49966_());
                return;
            }
            this.f_58857_.m_7471_(this.f_58858_, false);
        }
    }

    public InteractionResult onBlockUse(BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        MultiBlockController controller = this.getController();
        if (controller != null) {
            return controller.handleRemoteClick(player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    public VoxelShape getShape(CollisionContext context) {
        MultiBlockController controller = this.getController();
        return controller == null ? Shapes.m_83040_() : controller.getShapeForPart(this.m_58899_(), context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderSelectionBox(RenderHighlightEvent.Block event) {
        MultiBlockController controller = this.getController();
        return controller == null || controller.renderSelectionBox(event);
    }
}

