/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.mixin;

import dev.corgitaco.dataanchor.data.SyncedTrackedData;
import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerEntity.class})
public class ServerEntityMixin {
    @Shadow
    @Final
    private Entity f_8510_;

    @Inject(method={"addPairing"}, at={@At(value="RETURN")})
    private void dataAnchor$addPairing(ServerPlayer player, CallbackInfo ci) {
        Entity entity = this.f_8510_;
        if (entity instanceof TrackedDataContainer) {
            TrackedDataContainer trackedDataContainer = (TrackedDataContainer)entity;
            Collection<TrackedDataKey<TrackedDataKey>> keys = trackedDataContainer.dataAnchor$getTrackedDataKeys();
            keys.forEach(key -> trackedDataContainer.dataAnchor$getTrackedData(key).ifPresent(trackedData -> {
                if (trackedData instanceof SyncedTrackedData) {
                    SyncedTrackedData syncedTrackedData = (SyncedTrackedData)trackedData;
                    syncedTrackedData.syncToPlayer(player);
                }
            }));
        }
    }

    @Inject(method={"sendPairingData"}, at={@At(value="RETURN")})
    private void dataAnchor$sendPairingData(ServerPlayer player, Consumer<net.minecraft.network.protocol.Packet<ClientGamePacketListener>> consumer, CallbackInfo ci) {
        Entity entity = this.f_8510_;
        if (entity instanceof TrackedDataContainer) {
            TrackedDataContainer trackedDataContainer = (TrackedDataContainer)entity;
            Collection<TrackedDataKey<TrackedDataKey>> keys = trackedDataContainer.dataAnchor$getTrackedDataKeys();
            keys.forEach(key -> trackedDataContainer.dataAnchor$getTrackedData(key).ifPresent(trackedData -> {
                if (trackedData instanceof SyncedTrackedData) {
                    SyncedTrackedData syncedTrackedData = (SyncedTrackedData)trackedData;
                    Packet packet = syncedTrackedData.syncPacket();
                    FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf(Unpooled.buffer());
                    packet.write(friendlyByteBuf);
                    consumer.accept((net.minecraft.network.protocol.Packet<ClientGamePacketListener>)new ClientboundCustomPayloadPacket(PacketBroadcaster.S2C.channelName(packet.getClass()), friendlyByteBuf));
                    syncedTrackedData.syncToPlayer(player);
                }
            }));
        }
    }
}

