/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.data;

import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public interface TrackedData<T>
extends Supplier<T> {
    @Nullable
    default public CompoundTag save() {
        try {
            return (CompoundTag)TrackedData.toTag(this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    default public void load(CompoundTag tag) {
        try {
            TrackedData.updateExistingFromTag((Tag)tag, this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Tag toTag(Object obj) throws IllegalAccessException {
        if (obj instanceof Integer) {
            return IntTag.m_128679_((int)((Integer)obj));
        }
        if (obj instanceof Boolean) {
            return ByteTag.m_128266_((byte)((Boolean)obj != false ? (byte)1 : 0));
        }
        if (obj instanceof Long) {
            return LongTag.m_128882_((long)((Long)obj));
        }
        if (obj instanceof Float) {
            return FloatTag.m_128566_((float)((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return DoubleTag.m_128500_((double)((Double)obj));
        }
        if (obj instanceof Byte) {
            return ByteTag.m_128266_((byte)((Byte)obj));
        }
        if (obj instanceof Short) {
            return ShortTag.m_129258_((short)((Short)obj));
        }
        if (obj instanceof String) {
            return StringTag.m_129297_((String)((String)obj));
        }
        if (obj instanceof int[]) {
            return new IntArrayTag((int[])obj);
        }
        if (obj instanceof long[]) {
            return new LongArrayTag((long[])obj);
        }
        if (obj instanceof byte[]) {
            return new ByteArrayTag((byte[])obj);
        }
        if (obj instanceof float[]) {
            float[] floats = (float[])obj;
            ListTag list = new ListTag();
            for (float aFloat : floats) {
                list.add((Object)FloatTag.m_128566_((float)aFloat));
            }
            return list;
        }
        if (obj instanceof double[]) {
            ListTag list = new ListTag();
            for (double aDouble : (double[])obj) {
                list.add((Object)DoubleTag.m_128500_((double)aDouble));
            }
            return list;
        }
        if (obj instanceof boolean[]) {
            ListTag list = new ListTag();
            for (boolean b : (boolean[])obj) {
                list.add((Object)ByteTag.m_128266_((byte)(b ? (byte)1 : 0)));
            }
            return list;
        }
        if (obj instanceof short[]) {
            ListTag list = new ListTag();
            for (short s : (short[])obj) {
                list.add((Object)ShortTag.m_129258_((short)s));
            }
            return list;
        }
        if (obj instanceof char[]) {
            return StringTag.m_129297_((String)new String((char[])obj));
        }
        if (obj instanceof Collection) {
            ListTag listTag = new ListTag();
            for (Object o : (Collection)obj) {
                listTag.add((Object)TrackedData.toTag(o));
            }
            return listTag;
        }
        if (obj instanceof Map) {
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                compoundTag.m_128365_(entry.getKey().toString(), TrackedData.toTag(entry.getValue()));
            }
            return compoundTag;
        }
        if (obj instanceof Enum) {
            return StringTag.m_129297_((String)((Enum)obj).name());
        }
        CompoundTag tag = new CompoundTag();
        for (Field declaredField : obj.getClass().getDeclaredFields()) {
            int modifiers = declaredField.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            declaredField.setAccessible(true);
            Object obj1 = declaredField.get(obj);
            if (obj1 == null) continue;
            tag.m_128365_(declaredField.getName(), TrackedData.toTag(obj1));
        }
        return tag;
    }

    public static <T> T updateExistingFromTag(Tag tag, T obj) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            for (Field declaredField : obj.getClass().getDeclaredFields()) {
                int i;
                ListTag list;
                Class<?> declaringClass;
                SerializedName annotation;
                int modifiers = declaredField.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                declaredField.setAccessible(true);
                String name = declaredField.getName();
                if (declaredField.isAnnotationPresent(SerializedName.class) && !compoundTag.m_128441_(name = (annotation = declaredField.getAnnotation(SerializedName.class)).value()) && annotation.alternate().length > 0) {
                    for (String string : annotation.alternate()) {
                        if (!compoundTag.m_128441_(string)) continue;
                        name = string;
                        break;
                    }
                }
                if ((declaringClass = declaredField.getType()).isPrimitive()) {
                    if (declaringClass == Boolean.TYPE || declaringClass == Boolean.class) {
                        declaredField.set(obj, compoundTag.m_128471_(name));
                    }
                    if (declaringClass == Integer.TYPE || declaringClass == Integer.class) {
                        declaredField.set(obj, compoundTag.m_128451_(name));
                    }
                    if (declaringClass == Long.TYPE || declaringClass == Long.class) {
                        declaredField.set(obj, compoundTag.m_128454_(name));
                    }
                    if (declaringClass == Float.TYPE || declaringClass == Float.class) {
                        declaredField.set(obj, Float.valueOf(compoundTag.m_128457_(name)));
                    }
                    if (declaringClass == Double.TYPE || declaringClass == Double.class) {
                        declaredField.set(obj, compoundTag.m_128459_(name));
                    }
                    if (declaringClass == Byte.TYPE || declaringClass == Byte.class) {
                        declaredField.set(obj, compoundTag.m_128445_(name));
                    }
                    if (declaringClass == Short.TYPE || declaringClass == Short.class) {
                        declaredField.set(obj, compoundTag.m_128448_(name));
                    }
                    if (declaringClass == Character.TYPE || declaringClass == Character.class) {
                        declaredField.set(obj, Character.valueOf((char)compoundTag.m_128451_(name)));
                    }
                }
                if (declaringClass == String.class) {
                    declaredField.set(obj, compoundTag.m_128461_(name));
                }
                if (declaringClass.isInstance(Collection.class)) {
                    Object o = declaredField.get(obj);
                    if (o instanceof Collection) {
                        Collection collection = (Collection)o;
                        collection.clear();
                        ListTag list2 = compoundTag.m_128437_(name, (int)compoundTag.m_7060_());
                        for (Tag tag12 : list2) {
                            collection.add(TrackedData.fromTag(tag12, null));
                        }
                    }
                    declaredField.set(obj, compoundTag.m_128437_(name, (int)compoundTag.m_7060_()));
                }
                if (declaredField.getType().isEnum()) {
                    declaredField.set(obj, Enum.valueOf(declaredField.getType(), compoundTag.m_128461_(name)));
                }
                if (!declaredField.getType().isArray()) continue;
                if (declaringClass == int[].class) {
                    declaredField.set(obj, compoundTag.m_128465_(name));
                }
                if (declaringClass == long[].class) {
                    declaredField.set(obj, compoundTag.m_128467_(name));
                }
                if (declaringClass == byte[].class) {
                    declaredField.set(obj, compoundTag.m_128463_(name));
                }
                if (declaringClass == float[].class) {
                    list = compoundTag.m_128437_(name, 5);
                    float[] result = new float[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        FloatTag floatTag = (FloatTag)list.get(i);
                        result[i] = floatTag.m_7057_();
                    }
                    declaredField.set(obj, result);
                }
                if (declaringClass == double[].class) {
                    list = compoundTag.m_128437_(name, 6);
                    double[] result = new double[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        DoubleTag doubleTag = (DoubleTag)list.get(i);
                        result[i] = doubleTag.m_7061_();
                    }
                    declaredField.set(obj, result);
                }
                if (declaringClass == boolean[].class) {
                    list = compoundTag.m_128437_(name, 1);
                    boolean[] result = new boolean[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        ByteTag byteTag = (ByteTag)list.get(i);
                        result[i] = byteTag.m_7063_() == 1;
                    }
                    declaredField.set(obj, result);
                }
                if (declaringClass == short[].class) {
                    list = compoundTag.m_128437_(name, 2);
                    short[] result = new short[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        ShortTag shortTag = (ShortTag)list.get(i);
                        result[i] = shortTag.m_7053_();
                    }
                    declaredField.set(obj, result);
                }
                if (declaringClass == char[].class) {
                    list = compoundTag.m_128437_(name, 3);
                    char[] result = new char[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        IntTag intTag = (IntTag)list.get(i);
                        result[i] = (char)intTag.m_7047_();
                    }
                    declaredField.set(obj, result);
                }
                if (!declaringClass.isInstance(Map.class)) continue;
                declaredField.set(obj, TrackedData.fromTag(compoundTag.m_128423_(name), declaredField.getType()));
            }
        }
        return obj;
    }

    public static <T> T fromTag(Tag tag, Class<T> clazz) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            return (T)Integer.valueOf(intTag.m_7047_());
        }
        if (tag instanceof LongTag) {
            LongTag longTag = (LongTag)tag;
            return (T)Long.valueOf(longTag.m_7046_());
        }
        if (tag instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tag;
            return (T)Float.valueOf(floatTag.m_7057_());
        }
        if (tag instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)tag;
            return (T)Double.valueOf(doubleTag.m_7061_());
        }
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            return (T)Byte.valueOf(byteTag.m_7063_());
        }
        if (tag instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)tag;
            return (T)Short.valueOf(shortTag.m_7053_());
        }
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            if (clazz.isEnum()) {
                return Enum.valueOf(clazz, stringTag.m_7916_());
            }
            return (T)stringTag.m_7916_();
        }
        if (tag instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)tag;
            return (T)intArrayTag.m_128648_();
        }
        if (tag instanceof LongArrayTag) {
            LongArrayTag longArrayTag = (LongArrayTag)tag;
            return (T)longArrayTag.m_128851_();
        }
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag byteArrayTag = (ByteArrayTag)tag;
            return (T)byteArrayTag.m_128227_();
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            HashMap<String, Tag> entries = new HashMap<String, Tag>();
            for (String key : compoundTag.m_128431_()) {
                entries.put(key, compoundTag.m_128423_(key));
            }
            T t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field declaredField : clazz.getDeclaredFields()) {
                int modifiers = declaredField.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                declaredField.setAccessible(true);
                String name = TrackedData.getName(declaredField, entries);
                Tag tag1 = (Tag)entries.get(name);
                if (tag1 == null) continue;
                declaredField.set(t, TrackedData.fromTag(tag1, declaredField.getType()));
            }
            return t;
        }
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            T t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (t instanceof Collection) {
                Collection collection = (Collection)t;
                for (Tag tag1 : listTag) {
                    collection.add(TrackedData.fromTag(tag1, clazz));
                }
            }
            return t;
        }
        return null;
    }

    private static String getName(Field declaredField, Map<String, Tag> entries) {
        SerializedName annotation;
        String name = declaredField.getName();
        if (declaredField.isAnnotationPresent(SerializedName.class) && !entries.containsKey(name = (annotation = declaredField.getAnnotation(SerializedName.class)).value()) && annotation.alternate().length > 0) {
            for (String s : annotation.alternate()) {
                if (!entries.containsKey(s)) continue;
                name = s;
                break;
            }
        }
        return name;
    }
}

