/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.animation.AnimationHandler;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.AnimationTrigger;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.model.ScaleData;
import com.tom.cpm.shared.network.ServerCaps;
import com.tom.cpm.shared.network.packet.GestureC2S;
import com.tom.cpm.shared.parts.anim.ParameterDetails;
import com.tom.cpm.shared.parts.anim.menu.CommandAction;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.ScalingOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class AnimationEngine {
    private long tickCounter;
    private float partial;
    private ScaleData modelScale;
    private ScaleData modelScaleToReset;
    private long resetCounter;
    private boolean[] quickAccessPressed = new boolean[16];
    private int gestureAutoResetTimer = -1;
    private ParameterDetails lastDetails;
    private byte[] gestureData = new byte[2];
    private boolean gesturesChanged;
    private boolean checkedUUID;

    public void tick() {
        ++this.tickCounter;
        if (MinecraftClientAccess.get().isInGame()) {
            Player<?> player = MinecraftClientAccess.get().getCurrentClientPlayer();
            ModelDefinition def = player.getModelDefinition();
            if (def != null) {
                ParameterDetails param = def.getAnimations().getParams();
                if (this.lastDetails != param) {
                    byte v0 = this.gestureData[0];
                    byte v1 = this.gestureData[1];
                    this.gestureData = param.createSyncParams();
                    this.gestureData[0] = v0;
                    this.gestureData[1] = v1;
                    if (def.getAnimations().getProfileId() != null) {
                        ConfigEntry vals = ModConfig.getCommonConfig().getEntry("modelProperties").getEntry(def.getAnimations().getProfileId()).getEntry("values");
                        def.getAnimations().getNamedActions().forEach(a -> {
                            if (a.isProperty()) {
                                a.loadFrom(vals);
                            }
                        });
                    }
                    this.gesturesChanged = true;
                    this.lastDetails = param;
                }
                if (player.animState.gestureData == null) {
                    player.animState.gestureData = Arrays.copyOf(this.gestureData, this.gestureData.length);
                }
            }
            if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
                if (def != null && def.doRender()) {
                    player.sendEventSubs();
                    if (this.resetCounter > this.tickCounter) {
                        this.resetCounter = 0L;
                        this.modelScale = this.modelScaleToReset;
                        this.modelScaleToReset = null;
                    }
                    if (!Objects.equals(def.getScale(), this.modelScale)) {
                        this.modelScale = def.getScale();
                        if (this.modelScale == null) {
                            MinecraftClientAccess.get().setModelScale(null);
                        } else {
                            MinecraftClientAccess.get().setModelScale(this.modelScale);
                        }
                    }
                } else if (this.modelScale != null) {
                    MinecraftClientAccess.get().setModelScale(null);
                    this.modelScale = null;
                }
            }
            if (this.gestureAutoResetTimer >= 0) {
                --this.gestureAutoResetTimer;
            }
            if (this.gestureAutoResetTimer == 0 && def != null) {
                this.clearGesture(def);
            }
            if (!this.checkedUUID) {
                UUID server;
                this.checkedUUID = true;
                ModelDefinitionLoader dl = MinecraftClientAccess.get().getDefinitionLoader();
                UUID client = dl.getGP_UUID(MinecraftClientAccess.get().getPlayerIDObject());
                if (!Objects.equals(client, server = dl.getGP_UUID(MinecraftClientAccess.get().getCurrentPlayerIDObject())) && ModConfig.getCommonConfig().getBoolean("showIngameWarnings", true)) {
                    MinecraftClientAccess.get().getNetHandler().displayText(new FormatText("chat.cpm.clientUUIDMismatch", new Object[0]));
                }
            }
        } else {
            this.checkedUUID = false;
            this.modelScale = null;
            Arrays.fill(this.quickAccessPressed, false);
            this.gestureAutoResetTimer = -1;
        }
    }

    public void update(float partial) {
        this.partial = partial;
    }

    public long getTime() {
        return (long)(((float)this.tickCounter + this.partial) * 50.0f);
    }

    public void prepareAnimations(Player<?> player, AnimationMode mode, ModelDefinition def) {
        long time = this.getTime();
        AnimationRegistry reg = def.getAnimations();
        if (mode == AnimationMode.PLAYER) {
            player.animState.preAnimate();
            VanillaPose pose = player.animState.getMainPose(time, reg);
            if (MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES) && player.animState.gestureData != null && player.animState.gestureData.length > 1) {
                if (player.animState.gestureData[0] == 0) {
                    player.currentPose = pose;
                } else {
                    player.currentPose = reg.getPoseById(player.animState.gestureData[0], player.currentPose);
                    player.prevPose = pose;
                }
            } else {
                int gesture = player.animState.encodedState;
                if (pose != player.prevPose || gesture == reg.getPoseResetId()) {
                    player.currentPose = pose;
                }
                player.currentPose = reg.getPoseEncoded(gesture, player.currentPose);
                player.prevPose = pose;
            }
        }
        reg.tickAnimated(time, false);
    }

    public void handleAnimation(Player<?> player, AnimationMode mode, ModelDefinition def) {
        if (mode == AnimationMode.PLAYER) {
            if (player.animState.firstPersonMod) {
                mode = AnimationMode.FIRST_PERSON;
            } else if (player.animState.inGui) {
                mode = AnimationMode.GUI;
            }
        }
        AnimationHandler h = player.getAnimationHandler(mode);
        try {
            long time = this.getTime();
            AnimationRegistry reg = def.getAnimations();
            switch (mode) {
                case HAND: {
                    def.resetAnimationPos();
                    VanillaPose pose = player.animState.vrState == AnimationState.VRState.FIRST_PERSON ? VanillaPose.VR_FIRST_PERSON : VanillaPose.FIRST_PERSON_HAND;
                    List<AnimationTrigger> a = reg.getPoseAnimations(pose);
                    h.addAnimations(a, pose);
                    break;
                }
                case PLAYER: 
                case FIRST_PERSON: 
                case GUI: {
                    player.animState.preAnimate();
                    List<AnimationTrigger> anim = reg.getPoseAnimations(player.currentPose);
                    h.addAnimations(anim, player.currentPose);
                    player.animState.collectAnimations(p -> h.addAnimations(reg.getPoseAnimations((IPose)p), (IPose)p), reg);
                    break;
                }
                case SKULL: {
                    List<AnimationTrigger> anim = reg.getPoseAnimations(VanillaPose.SKULL_RENDER);
                    List<AnimationTrigger> global = reg.getPoseAnimations(VanillaPose.GLOBAL);
                    h.addAnimations(anim, VanillaPose.SKULL_RENDER);
                    h.addAnimations(global, VanillaPose.GLOBAL);
                    break;
                }
            }
            h.animate(player.animState, time);
        }
        catch (Exception e) {
            Log.warn("Error animating model", e);
            try {
                def.resetAnimationPos();
                h.clear();
            }
            catch (Exception ex) {
                ex.addSuppressed(e);
                Log.error("Error animating model", e);
                def.setError(ex);
            }
        }
    }

    public void handleGuiAnimation(AnimationHandler h, ModelDefinition def) {
        try {
            long time = this.getTime();
            AnimationRegistry reg = def.getAnimations();
            reg.tickAnimated(time, true);
            List<AnimationTrigger> anim = def.getAnimations().getPoseAnimations(VanillaPose.STANDING);
            List<AnimationTrigger> global = def.getAnimations().getPoseAnimations(VanillaPose.GLOBAL);
            List<AnimationTrigger> inGui = def.getAnimations().getPoseAnimations(VanillaPose.IN_GUI);
            h.addAnimations(anim, VanillaPose.STANDING);
            h.addAnimations(global, VanillaPose.GLOBAL);
            h.addAnimations(inGui, VanillaPose.IN_GUI);
            h.animate(null, time);
        }
        catch (Exception e) {
            Log.warn("Error animating model", e);
            def.resetAnimationPos();
            h.clear();
        }
    }

    private void sendGestureData() {
        if (MinecraftObjectHolder.DEBUGGING) {
            Log.debug("Gesture Sync: " + Arrays.toString(this.gestureData));
        }
        MinecraftClientAccess.get().getNetHandler().sendPacketToServer(new GestureC2S(this.gestureData));
    }

    public int getTicks() {
        return (int)this.tickCounter;
    }

    public void setServerScaling(Map<ScalingOptions, Float> scaling) {
        this.modelScaleToReset = new ScaleData(scaling);
        this.resetCounter = this.tickCounter + 100L;
    }

    public static ConfigEntry getEntryForModel(ModelDefinition def, boolean make) {
        ConfigEntry cem;
        String pf = def.getAnimations().getProfileId();
        if (pf != null && ((cem = ModConfig.getCommonConfig().getEntry("keybindPerModel")).hasEntry(pf) || make)) {
            boolean copy = !cem.hasEntry(pf);
            ConfigEntry cfg = cem.getEntry(pf);
            if (copy) {
                ConfigEntry ce = ModConfig.getCommonConfig().getEntry("keybinds");
                for (String k : ce.keySet()) {
                    cfg.setString(k, ce.getString(k, ""));
                }
            }
            return cfg;
        }
        return ModConfig.getCommonConfig().getEntry("keybinds");
    }

    public void updateKeys(IKeybind[] kbs) {
        Player<?> pl = MinecraftClientAccess.get().getCurrentClientPlayer();
        ModelDefinition def = pl.getModelDefinition();
        if (def != null) {
            ConfigEntry ce = AnimationEngine.getEntryForModel(def, false);
            for (int i = 1; i <= kbs.length; ++i) {
                IKeybind kb = kbs[i - 1];
                boolean pr = kb.isPressed();
                boolean prevPr = this.quickAccessPressed[i - 1];
                if (!prevPr && pr) {
                    mode = ce.getString("qa_" + i + "_mode", "press");
                    c = ce.getString("qa_" + i, null);
                    if (c != null) {
                        sp = c.split("/");
                        dt = def.getAnimations().getNamedActionByKeybind().get(sp[0]);
                        if (dt != null) {
                            dt.onKeybind(sp.length > 1 ? sp[1] : null, true, !mode.equals("hold"));
                        }
                    }
                } else if (prevPr && !pr) {
                    mode = ce.getString("qa_" + i + "_mode", "press");
                    c = ce.getString("qa_" + i, null);
                    if (c != null && mode.equals("hold")) {
                        sp = c.split("/");
                        dt = def.getAnimations().getNamedActionByKeybind().get(sp[0]);
                        if (dt != null) {
                            dt.onKeybind(sp.length > 1 ? sp[1] : null, false, false);
                        }
                    }
                }
                this.quickAccessPressed[i - 1] = pr;
            }
            if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED && this.gesturesChanged) {
                this.sendGestureData();
                this.gesturesChanged = false;
            }
        } else {
            Arrays.fill(this.quickAccessPressed, false);
        }
    }

    public void resetGestureData() {
        this.gestureData = new byte[2];
    }

    public boolean applyCommand(String id, int value, Boolean cmd) {
        CommandAction ca;
        Player<?> pl = MinecraftClientAccess.get().getCurrentClientPlayer();
        ModelDefinition def = pl.getModelDefinition();
        if (def != null && (ca = def.getAnimations().getCommandActionsMap().get(id)) != null && (cmd == null || ca.isCommandControlled() == cmd.booleanValue())) {
            ca.setValue(value);
            return true;
        }
        return false;
    }

    public void clearCustomPose(ModelDefinition def) {
        if (MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES)) {
            this.setGestureValue(0, 0);
        } else {
            MinecraftClientAccess.get().setEncodedGesture(def.getAnimations().getPoseResetId());
        }
    }

    public void clearGesture(ModelDefinition def) {
        if (MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES)) {
            this.setGestureValue(1, 0);
        } else {
            MinecraftClientAccess.get().setEncodedGesture(def.getAnimations().getBlankGesture());
        }
        this.gestureAutoResetTimer = -1;
    }

    public byte getGestureValue(int id) {
        return this.gestureData.length > id && id >= 0 ? this.gestureData[id] : (byte)0;
    }

    public void setGestureValue(int id, int val) {
        if (MinecraftObjectHolder.DEBUGGING) {
            Log.debug("Set: " + id + " to " + val);
        }
        if (this.gestureData.length > id && id >= 0) {
            byte v = (byte)val;
            if (this.gestureData[id] != v) {
                this.gestureData[id] = v;
                this.gesturesChanged = true;
            }
        } else {
            Log.error("Parameter out of bounds", new IndexOutOfBoundsException(id + ", len=" + this.gestureData.length));
        }
    }

    public void setGestureTimeout(int gestureTimeout) {
        this.gestureAutoResetTimer = gestureTimeout;
    }

    public static enum AnimationMode {
        PLAYER,
        SKULL,
        HAND,
        GUI,
        FIRST_PERSON;

    }
}

