/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.skin.TextureProvider;

public class AnimatedTexture {
    private final ModelDefinition def;
    private final TextureSheetType sheet;
    private final Vec2i uvStart;
    private final Vec2i uvSize;
    private final Vec2i animStart;
    private final int frameTime;
    private final int frameCount;
    private final boolean anX;
    private final boolean interpolate;
    private int lastFrame;
    private long lastUpdate;

    public AnimatedTexture(ModelDefinition def, TextureSheetType sheet, Vec2i uvStart, Vec2i uvSize, Vec2i animStart, int frameCount, int frameTime, boolean anX, boolean interpolate) {
        this.def = def;
        this.sheet = sheet;
        this.uvStart = uvStart;
        this.uvSize = uvSize;
        this.animStart = animStart;
        this.frameCount = frameCount;
        this.frameTime = frameTime;
        this.anX = anX;
        this.interpolate = interpolate;
    }

    public void update(long time, boolean inGui) {
        if (this.frameCount == 0 || this.frameTime == 0) {
            return;
        }
        int frm = (int)(time / (long)this.frameTime % (long)this.frameCount);
        if (this.interpolate) {
            if (time - this.lastUpdate > 50L) {
                TextureProvider tex = this.def.getTexture(this.sheet, inGui);
                Image img = tex.getImage();
                float t = (float)frm + (float)(time % (long)this.frameTime) / (float)this.frameTime;
                int uvx = this.uvStart.x;
                int uvy = this.uvStart.y;
                int sx = this.uvSize.x;
                int sy = this.uvSize.y;
                int ax = this.animStart.x;
                int ay = this.animStart.y;
                AnimatedTexture.copyTextureInt(img, img, uvx, uvy, sx, sy, ax, ay, t, this.anX, this.frameCount);
                if (tex.texture != null) {
                    tex.texture.markDirty();
                }
            }
        } else if (frm != this.lastFrame) {
            TextureProvider tex = this.def.getTexture(this.sheet, inGui);
            Image img = tex.getImage();
            this.lastFrame = frm;
            int uvx = this.uvStart.x;
            int uvy = this.uvStart.y;
            int sx = this.uvSize.x;
            int sy = this.uvSize.y;
            int ax = this.animStart.x;
            int ay = this.animStart.y;
            AnimatedTexture.copyTexture(img, img, uvx, uvy, sx, sy, ax, ay, frm, this.anX);
            if (tex.texture != null) {
                tex.texture.markDirty();
            }
        }
    }

    public static void copyTexture(Image dest, Image img, int uvx, int uvy, int sx, int sy, int ax, int ay, int frame, boolean anX) {
        if (anX) {
            ax += sx * frame;
        } else {
            ay += sy * frame;
        }
        for (int x = 0; x < sx; ++x) {
            int x1 = x + ax;
            int x2 = x + uvx;
            if (x1 < 0 || x1 >= img.getWidth() || x2 < 0 || x2 >= dest.getWidth()) continue;
            for (int y = 0; y < sy; ++y) {
                int y1 = y + ay;
                int y2 = y + uvy;
                if (y1 < 0 || y1 >= img.getHeight() || y2 < 0 || y2 >= dest.getHeight()) continue;
                dest.setRGB(x2, y2, img.getRGB(x1, y1));
            }
        }
    }

    public static void copyTextureInt(Image dest, Image img, int uvx, int uvy, int sx, int sy, int axIn, int ayIn, float time, boolean anX, int frms) {
        int frame = (int)time;
        float subfrm = 1.0f - (time - (float)frame);
        int axf = axIn;
        int ayf = ayIn;
        int axs = axIn;
        int ays = ayIn;
        if (anX) {
            axf = axIn + sx * frame;
            axs = axIn + sx * ((frame + 1) % frms);
        } else {
            ayf = ayIn + sy * frame;
            ays = ayIn + sy * ((frame + 1) % frms);
        }
        for (int x = 0; x < sx; ++x) {
            int xf = x + axf;
            int xs = x + axs;
            int x2 = x + uvx;
            if (xf < 0 || xf >= img.getWidth() || xs < 0 || xs >= img.getWidth() || x2 < 0 || x2 >= dest.getWidth()) continue;
            for (int y = 0; y < sy; ++y) {
                int yf = y + ayf;
                int ys = y + ays;
                int y2 = y + uvy;
                if (yf < 0 || yf >= img.getHeight() || ys < 0 || ys >= img.getHeight() || y2 < 0 || y2 >= dest.getHeight()) continue;
                int first = img.getRGB(xf, yf);
                int second = img.getRGB(xs, ys);
                int r = AnimatedTexture.mix(subfrm, first >> 16 & 0xFF, second >> 16 & 0xFF);
                int g = AnimatedTexture.mix(subfrm, first >> 8 & 0xFF, second >> 8 & 0xFF);
                int b = AnimatedTexture.mix(subfrm, first & 0xFF, second & 0xFF);
                dest.setRGB(x2, y2, first & 0xFF000000 | r << 16 | g << 8 | b);
            }
        }
    }

    private static int mix(float time, int first, int second) {
        return (int)(time * (float)first + (1.0f - time) * (float)second);
    }
}

