/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.api;

import com.tom.cpl.function.ToFloatFunction;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpl.render.RenderTypeBuilder;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.api.CPMApiManager;
import com.tom.cpm.api.ICPMPlugin;
import com.tom.cpm.api.IClientAPI;
import com.tom.cpm.api.SharedApi;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Generators;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import com.tom.cpm.shared.parts.anim.menu.CommandAction;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ClientApi
extends SharedApi
implements IClientAPI {
    private List<ToFloatFunction<Object>> voice = new ArrayList<ToFloatFunction<Object>>();
    private List<Predicate<Object>> voiceMuted = new ArrayList<Predicate<Object>>();
    private TextureHandlerFactory<?, ?> textureHandlerFactory;
    private BiFunction<UUID, String, ?> gameProfileFactory;
    private Function<Object, UUID> getPlayerUUID;
    private Map<String, BiConsumer<Object, NBTTagCompound>> pluginMessageHandlers = new HashMap<String, BiConsumer<Object, NBTTagCompound>>();

    @Override
    protected void callInit0(ICPMPlugin plugin) {
        plugin.initClient(this);
    }

    protected ClientApi() {
    }

    @Override
    public <T> void registerVoice(Class<T> clazz, Function<T, Float> getVoiceLevel) {
        if (this.checkClass(clazz, SharedApi.Clazz.PLAYER)) {
            return;
        }
        this.voice.add(p -> ((Float)getVoiceLevel.apply(p)).floatValue());
    }

    @Override
    public void registerVoice(Function<UUID, Float> getVoiceLevel) {
        this.voice.add(p -> ((Float)getVoiceLevel.apply(this.getPlayerUUID.apply(p))).floatValue());
    }

    @Override
    public <T> void registerVoiceMute(Class<T> clazz, Predicate<T> getMuted) {
        if (this.checkClass(clazz, SharedApi.Clazz.PLAYER)) {
            return;
        }
        this.voiceMuted.add(p -> getMuted.test(p));
    }

    @Override
    public void registerVoiceMute(Predicate<UUID> getMuted) {
        this.voiceMuted.add(p -> getMuted.test(this.getPlayerUUID.apply(p)));
    }

    public List<ToFloatFunction<Object>> getVoiceProviders() {
        return this.voice;
    }

    public List<Predicate<Object>> getVoiceMutedProviders() {
        return this.voiceMuted;
    }

    public <HM, RL, RT, MBS, GP> IClientAPI.PlayerRenderer<HM, RL, RT, MBS, GP> createPlayerRenderer(Class<HM> humanoidModelClass, Class<RL> resourceLocationClass, Class<RT> renderTypeClass, Class<MBS> multiBufferSourceClass, Class<GP> gameProfileClass) {
        if (this.checkClass(humanoidModelClass, SharedApi.Clazz.MODEL)) {
            return null;
        }
        if (this.checkClass(resourceLocationClass, SharedApi.Clazz.RESOURCE_LOCATION)) {
            return null;
        }
        if (this.checkClass(renderTypeClass, SharedApi.Clazz.RENDER_TYPE)) {
            return null;
        }
        if (this.checkClass(multiBufferSourceClass, SharedApi.Clazz.MULTI_BUFFER_SOURCE)) {
            return null;
        }
        if (this.checkClass(gameProfileClass, SharedApi.Clazz.GAME_PROFILE)) {
            return null;
        }
        return new PlayerRendererImpl();
    }

    @Override
    public IClientAPI.LocalModel loadModel(String name, InputStream is) throws IOException {
        ModelFile file = ModelFile.load(name, is);
        Object gp = this.gameProfileFactory.apply(UUID.randomUUID(), name);
        return new LocalModelImpl(file, gp);
    }

    @Override
    public void registerEditorGenerator(String name, String tooltip, Consumer<EditorGui> func) {
        String modid = this.initingPlugin != null ? this.initingPlugin.getOwnerModId() : "?";
        Generators.generators.add(new Generators(name, new FormatText("tooltip.cpm.pluginGenerator", new FormatText(tooltip, new Object[0]), modid), func));
    }

    @Override
    public boolean playAnimation(String name, int value) {
        return MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().applyCommand(name, value, null);
    }

    @Override
    public boolean playAnimation(String name) {
        return this.playAnimation(name, -1);
    }

    @Override
    public int getAnimationPlaying(String name) {
        Player<?> pl = MinecraftClientAccess.get().getCurrentClientPlayer();
        ModelDefinition def = pl.getModelDefinition();
        if (def == null) {
            return -1;
        }
        CustomPose pose = def.getAnimations().getCustomPoses().get(name);
        if (pose == null) {
            CommandAction act = def.getAnimations().getCommandActionsMap().get(name);
            if (act != null) {
                return act.getValue();
            }
            return -1;
        }
        return pl.currentPose == pose ? 1 : 0;
    }

    @Override
    public int getAnimationMaxValue(String name) {
        Player<?> pl = MinecraftClientAccess.get().getCurrentClientPlayer();
        ModelDefinition def = pl.getModelDefinition();
        if (def == null) {
            return -1;
        }
        CommandAction act = def.getAnimations().getCommandActionsMap().get(name);
        if (act != null) {
            return act.getMaxValue();
        }
        return -1;
    }

    @Override
    public <P> IClientAPI.MessageSender registerPluginMessage(Class<P> clazz, String messageId, BiConsumer<P, NBTTagCompound> handler, boolean broadcastToTracking) {
        if (this.checkClass(clazz, SharedApi.Clazz.PLAYER)) {
            return null;
        }
        if (this.initingPlugin == null) {
            return null;
        }
        String fullID = this.initingPlugin.getOwnerModId() + ":" + messageId;
        this.pluginMessageHandlers.put(fullID, (a, b) -> handler.accept((Object)a, (NBTTagCompound)b));
        return ClientApi.sendPluginMsg(fullID, broadcastToTracking ? 1 : 0);
    }

    @Override
    public IClientAPI.MessageSender registerPluginMessage(String messageId, BiConsumer<UUID, NBTTagCompound> handler, boolean broadcastToTracking) {
        if (this.initingPlugin == null) {
            return null;
        }
        String fullID = this.initingPlugin.getOwnerModId() + ":" + messageId;
        this.pluginMessageHandlers.put(fullID, (a, b) -> handler.accept(this.getPlayerUUID.apply(a), (NBTTagCompound)b));
        return ClientApi.sendPluginMsg(fullID, broadcastToTracking ? 1 : 0);
    }

    private static IClientAPI.MessageSender sendPluginMsg(String fullID, int flags) {
        return msg -> MinecraftClientAccess.get().getNetHandler().sendPluginMessage(fullID, msg, flags);
    }

    public void handlePacket(String id, NBTTagCompound tag, Object player) {
        BiConsumer<Object, NBTTagCompound> h = this.pluginMessageHandlers.get(id);
        h.accept(player, tag);
    }

    @Override
    public <P> IClientAPI.MessageSender registerPluginStateMessage(Class<P> clazz, String messageId, BiConsumer<P, NBTTagCompound> handler) {
        if (this.checkClass(clazz, SharedApi.Clazz.PLAYER)) {
            return null;
        }
        if (this.initingPlugin == null) {
            return null;
        }
        String fullID = this.initingPlugin.getOwnerModId() + ":" + messageId;
        this.pluginMessageHandlers.put(fullID, (a, b) -> handler.accept((Object)a, (NBTTagCompound)b));
        return ClientApi.sendPluginMsg(fullID, 2);
    }

    @Override
    public IClientAPI.MessageSender registerPluginStateMessage(String messageId, BiConsumer<UUID, NBTTagCompound> handler) {
        if (this.initingPlugin == null) {
            return null;
        }
        String fullID = this.initingPlugin.getOwnerModId() + ":" + messageId;
        this.pluginMessageHandlers.put(fullID, (a, b) -> handler.accept(this.getPlayerUUID.apply(a), (NBTTagCompound)b));
        return ClientApi.sendPluginMsg(fullID, 2);
    }

    private class PlayerRendererImpl<M, RL, RT, MBS, GP>
    implements IClientAPI.PlayerRenderer<M, RL, RT, MBS, GP> {
        private M model;
        private List<M> subModels = new ArrayList<M>();
        private Function<RL, RT> renderTypeFactory;
        private AnimationState animState = new AnimationState();
        private RL defaultTexture;
        private GP gameProfile;
        private boolean setupTexture;
        private ModelDefinition def;
        private Map<M, RL> textureMap;
        private IClientAPI.LocalModel localModel;
        private String activePose;
        private String activeGesture;

        private PlayerRendererImpl() {
            this.setupTexture = ClientApi.this.classes.get((Object)SharedApi.Clazz.RESOURCE_LOCATION) != Void.class;
            this.textureMap = new HashMap<M, RL>();
        }

        @Override
        public void setRenderModel(M model) {
            this.model = model;
        }

        @Override
        public void setRenderType(Function<RL, RT> renderTypeFactory) {
            this.renderTypeFactory = renderTypeFactory;
        }

        @Override
        public RT getDefaultRenderType() {
            return this.renderTypeFactory.apply(this.defaultTexture);
        }

        @Override
        public RL getDefaultTexture() {
            return this.defaultTexture;
        }

        @Override
        public AnimationState getAnimationState() {
            return this.animState;
        }

        @Override
        public void preRender(MBS buffers, AnimationEngine.AnimationMode renderMode) {
            String unique;
            if (this.localModel != null) {
                this.localModel.startRender();
                unique = this.localModel.getUniqueKey();
            } else {
                unique = "api";
            }
            ModelRenderManager mngr = (ModelRenderManager)MinecraftClientAccess.get().getPlayerRenderManager();
            Player<?> profile = MinecraftClientAccess.get().getDefinitionLoader().loadPlayer(this.gameProfile, unique);
            if (profile == null) {
                return;
            }
            this.def = profile.getModelDefinition();
            if (this.def != null) {
                profile.animState = this.animState;
                this.animState.encodedState = 0;
                CustomPose pose = this.def.getAnimations().getCustomPoses().get(this.activePose);
                if (pose != null) {
                    profile.currentPose = pose;
                } else {
                    profile.prevPose = null;
                }
                this.def.itemTransforms.clear();
                mngr.bindModel(this.model, "api", buffers, this.def, profile, renderMode);
                mngr.getAnimationEngine().prepareAnimations(profile, renderMode, this.def);
                if (this.setupTexture) {
                    RenderTypeBuilder.TextureHandler<Object, ?> tex = ClientApi.this.textureHandlerFactory.apply(null, this.renderTypeFactory);
                    mngr.bindSkin(this.model, tex, TextureSheetType.SKIN);
                    this.defaultTexture = tex.getTexture();
                } else {
                    mngr.bindSkin(this.model, null, TextureSheetType.SKIN);
                }
            }
        }

        private void prepareSubModel(M model, String arg, RL tex, TextureSheetType sheet) {
            if (this.def == null) {
                return;
            }
            ModelRenderManager mngr = (ModelRenderManager)MinecraftClientAccess.get().getPlayerRenderManager();
            mngr.bindSubModel(this.model, model, arg);
            this.subModels.add(model);
            if (this.setupTexture && tex != null) {
                RenderTypeBuilder.TextureHandler<?, ?> texH = ClientApi.this.textureHandlerFactory.apply(tex, this.renderTypeFactory);
                mngr.bindSkin(model, texH, sheet);
                this.textureMap.put(model, texH.getTexture());
            } else {
                mngr.bindSkin(model, null, sheet);
            }
        }

        @Override
        public void postRender() {
            ModelRenderManager mngr = (ModelRenderManager)MinecraftClientAccess.get().getPlayerRenderManager();
            mngr.flushBatch(this.model, "api");
            mngr.unbindModel(this.model);
            this.subModels.forEach(mngr::unbindModel);
            this.subModels.clear();
            this.textureMap.clear();
            this.model = null;
            this.def = null;
            this.defaultTexture = null;
        }

        @Override
        public void setGameProfile(GP profile) {
            this.gameProfile = profile;
            this.localModel = null;
        }

        @Override
        public void prepareSubModel(M model, IClientAPI.SubModelType type, RL tex) {
            String arg = null;
            TextureSheetType sheet = TextureSheetType.SKIN;
            switch (type) {
                case ARMOR_INNER: {
                    arg = "armor2";
                    sheet = TextureSheetType.ARMOR2;
                    break;
                }
                case ARMOR_OUTER: {
                    arg = "armor1";
                    sheet = TextureSheetType.ARMOR1;
                    break;
                }
                case ELYTRA: {
                    sheet = TextureSheetType.ELYTRA;
                    break;
                }
                case CAPE: {
                    sheet = TextureSheetType.CAPE;
                    break;
                }
            }
            this.prepareSubModel(model, arg, tex, sheet);
        }

        @Override
        public RT getRenderTypeForSubModel(M model) {
            return this.renderTypeFactory.apply(this.textureMap.get(model));
        }

        @Override
        public void setLocalModel(IClientAPI.LocalModel model) {
            this.setGameProfile(model.getGameProfile());
            this.localModel = model;
        }

        @Override
        public void setActivePose(String pose) {
            this.activePose = pose;
        }

        @Override
        public void setActiveGesture(String gesture) {
            this.activeGesture = gesture;
        }
    }

    private class LocalModelImpl
    implements IClientAPI.LocalModel {
        private ModelFile file;
        private Object gameProfile;
        private String unique;

        public LocalModelImpl(ModelFile file, Object gp) {
            this.file = file;
            this.gameProfile = gp;
            this.unique = "model:" + Base64.getEncoder().encodeToString(file.getDataBlock());
        }

        @Override
        public <GP> GP getGameProfile() {
            return (GP)this.gameProfile;
        }

        @Override
        public void startRender() {
            this.file.registerLocalCache(MinecraftClientAccess.get().getDefinitionLoader());
        }

        @Override
        public String getUniqueKey() {
            return this.unique;
        }
    }

    public static interface TextureHandlerFactory<RL, RT> {
        public RenderTypeBuilder.TextureHandler<RL, RT> apply(RL var1, Function<RL, RT> var2);
    }

    public static class ApiBuilder {
        private final CPMApiManager api;

        protected ApiBuilder(CPMApiManager api) {
            this.api = api;
            api.client = new ClientApi();
        }

        public <P> ApiBuilder voicePlayer(Class<P> player, Function<P, UUID> getUUID) {
            this.api.client.classes.put(SharedApi.Clazz.PLAYER, player);
            this.api.client.getPlayerUUID = getUUID;
            return this;
        }

        public <RL, RT> ApiBuilder renderApi(Class<?> playerModel, Class<RL> resLoc, Class<RT> renderType, Class<?> multiBuffer, Class<?> gp, TextureHandlerFactory<RL, RT> thf) {
            this.api.client.classes.put(SharedApi.Clazz.MODEL, playerModel);
            this.api.client.classes.put(SharedApi.Clazz.RESOURCE_LOCATION, resLoc);
            this.api.client.classes.put(SharedApi.Clazz.RENDER_TYPE, renderType);
            this.api.client.classes.put(SharedApi.Clazz.MULTI_BUFFER_SOURCE, multiBuffer);
            this.api.client.classes.put(SharedApi.Clazz.GAME_PROFILE, gp);
            this.api.client.textureHandlerFactory = thf;
            return this;
        }

        public ApiBuilder renderApi(Class<?> playerModel, Class<?> gp) {
            this.api.client.classes.put(SharedApi.Clazz.MODEL, playerModel);
            this.api.client.classes.put(SharedApi.Clazz.RESOURCE_LOCATION, Void.class);
            this.api.client.classes.put(SharedApi.Clazz.RENDER_TYPE, Void.class);
            this.api.client.classes.put(SharedApi.Clazz.MULTI_BUFFER_SOURCE, Void.class);
            this.api.client.classes.put(SharedApi.Clazz.GAME_PROFILE, gp);
            return this;
        }

        public <GP> ApiBuilder localModelApi(BiFunction<UUID, String, GP> newGP) {
            this.api.client.gameProfileFactory = newGP;
            return this;
        }

        public void init() {
            this.api.initClient();
        }
    }
}

