/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.math.Box;

public class MessagePopup
extends PopupPanel
implements Runnable {
    private String title;
    private Frame frame;

    public MessagePopup(Frame frame, String title, String text) {
        this(frame, title, text, frame.gui.i18nFormat("button.cpm.ok", new Object[0]));
    }

    public MessagePopup(Frame frame, String title, String text, String closeBtn) {
        super(frame.getGui());
        int w;
        int i;
        this.frame = frame;
        this.title = title;
        String[] lines = this.gui.wordWrap(text, frame.getBounds().w - 200).split("\\\\");
        int wm = 180;
        for (i = 0; i < lines.length; ++i) {
            w = this.gui.textWidth(lines[i]);
            if (w <= wm) continue;
            wm = w;
        }
        for (i = 0; i < lines.length; ++i) {
            w = this.gui.textWidth(lines[i]);
            this.addElement(new Label(this.gui, lines[i]).setBounds(new Box(wm / 2 - w / 2 + 10, 5 + i * 10, 0, 0)));
        }
        this.setBounds(new Box(0, 0, wm + 20, 45 + lines.length * 10));
        Button ok = new Button(this.gui, closeBtn, this::close);
        ok.setBounds(new Box(wm / 2 - 10, 20 + lines.length * 10, 40, 20));
        this.addElement(ok);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void run() {
        this.frame.openPopup(this);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (event.matches(this.gui.getKeyCodes().KEY_ENTER)) {
            this.close();
            event.consume();
        }
        super.keyPressed(event);
    }
}

