/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.type;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction1D;
import com.blamejared.crafttweaker.api.recipe.serializer.CTShapelessRecipeSerializer;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class CTShapelessRecipe
extends ShapelessRecipe {
    private final IIngredient[] ctIngredients;
    private final IItemStack output;
    @Nullable
    private final RecipeFunction1D function;

    public CTShapelessRecipe(String name, IItemStack output, IIngredient[] ingredients, @Nullable RecipeFunction1D function) {
        this(name, CraftingBookCategory.MISC, output, ingredients, function);
    }

    public CTShapelessRecipe(String name, CraftingBookCategory category, IItemStack output, IIngredient[] ingredients, @Nullable RecipeFunction1D function) {
        super(CraftTweakerConstants.rl(name), "", category, output.getInternal(), NonNullList.m_122779_());
        this.output = output;
        this.function = function;
        boolean containsNull = false;
        for (IIngredient ingredient : ingredients) {
            if (ingredient != null && !ingredient.asVanillaIngredient().m_43947_()) continue;
            CommonLoggers.api().warn("Shapeless recipe with ID '{}' contains null or empty ingredients, removing entries!", (Object)this.m_6423_());
            containsNull = true;
            break;
        }
        if (containsNull) {
            ingredients = (IIngredient[])Arrays.stream(ingredients).filter(Objects::nonNull).filter(iIngredient -> !iIngredient.asVanillaIngredient().m_43947_()).toArray(IIngredient[]::new);
        }
        this.ctIngredients = ingredients;
        this.m_7527_().addAll(Arrays.stream(this.ctIngredients).map(IIngredient::asVanillaIngredient).toList());
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        boolean[] visited = this.forAllUniqueMatches((Container)inv, (ingredientIndex, matchingSlot, stack) -> {});
        int visitedCount = 0;
        for (int slot = 0; slot < visited.length; ++slot) {
            if (visited[slot]) {
                ++visitedCount;
                continue;
            }
            if (inv.m_8020_(slot).m_41619_()) continue;
            return false;
        }
        return visitedCount == this.ctIngredients.length;
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess access) {
        if (this.function == null) {
            return this.output.getInternal().m_41777_();
        }
        IItemStack[] stacks = new IItemStack[this.ctIngredients.length];
        this.forAllUniqueMatches((Container)inv, (ingredientIndex, matchingSlot, stack) -> {
            stacks[ingredientIndex] = stack.setAmount(1);
        });
        return this.function.process(this.output, stacks).getImmutableInternal();
    }

    @Nullable
    public RecipeFunction1D getFunction() {
        return this.function;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.output.getInternal().m_41777_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remainingItems = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        this.forAllUniqueMatches((Container)inv, (ingredientIndex, matchingSlot, stack) -> remainingItems.set(matchingSlot, (Object)this.ctIngredients[ingredientIndex].getRemainingItem(stack).getInternal()));
        return remainingItems;
    }

    private boolean[] forAllUniqueMatches(Container inv, ForAllUniqueAction action) {
        boolean[] visited = new boolean[inv.m_6643_()];
        block0: for (int ingredientIndex = 0; ingredientIndex < this.ctIngredients.length; ++ingredientIndex) {
            IIngredient ingredient = this.ctIngredients[ingredientIndex];
            for (int i = 0; i < inv.m_6643_(); ++i) {
                IItemStack stack;
                ItemStack stackInSlot;
                if (visited[i] || (stackInSlot = inv.m_8020_(i)).m_41619_() || !ingredient.matches(stack = IItemStack.of(stackInSlot))) continue;
                visited[i] = true;
                action.accept(ingredientIndex, i, stack);
                continue block0;
            }
        }
        return visited;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        for (IIngredient ingredient : this.ctIngredients) {
            ingredients.add((Object)ingredient.asVanillaIngredient());
        }
        return ingredients;
    }

    public RecipeSerializer<CTShapelessRecipe> m_7707_() {
        return CTShapelessRecipeSerializer.INSTANCE;
    }

    public IIngredient[] getCtIngredients() {
        return this.ctIngredients;
    }

    public IItemStack getCtOutput() {
        return this.output;
    }

    @FunctionalInterface
    private static interface ForAllUniqueAction {
        public void accept(int var1, int var2, IItemStack var3);
    }
}

