/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.coffeemachine.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.coffeemachine.CoffeeMachineMod;
import net.mcreator.coffeemachine.procedures.GetAppleJuiceProcedure;
import net.mcreator.coffeemachine.procedures.GetCoffeeProcedure;
import net.mcreator.coffeemachine.procedures.GetHoneyProcedure;
import net.mcreator.coffeemachine.procedures.GetLemonadeProcedure;
import net.mcreator.coffeemachine.procedures.GetMilkProcedure;
import net.mcreator.coffeemachine.procedures.GetWaterProcedure;
import net.mcreator.coffeemachine.procedures.OpenGUI2Procedure;
import net.mcreator.coffeemachine.procedures.OpenGUI5Procedure;
import net.mcreator.coffeemachine.world.inventory.CoffeeMachineGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CoffeeMachineGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public CoffeeMachineGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public CoffeeMachineGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(CoffeeMachineGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(CoffeeMachineGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            CoffeeMachineGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = CoffeeMachineGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenGUI5Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenGUI2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            GetWaterProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            GetMilkProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            GetHoneyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            GetLemonadeProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            GetAppleJuiceProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            GetCoffeeProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CoffeeMachineMod.addNetworkMessage(CoffeeMachineGUIButtonMessage.class, CoffeeMachineGUIButtonMessage::buffer, CoffeeMachineGUIButtonMessage::new, CoffeeMachineGUIButtonMessage::handler);
    }
}

