/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.coffeemachine.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.coffeemachine.CoffeeMachineMod;
import net.mcreator.coffeemachine.procedures.GetLiquidGoldProcedure;
import net.mcreator.coffeemachine.procedures.GetLiquidHydrogenProcedure;
import net.mcreator.coffeemachine.procedures.GetLoquidIronProcedure;
import net.mcreator.coffeemachine.procedures.GetMercuryProcedure;
import net.mcreator.coffeemachine.procedures.GetSupriseProcedure;
import net.mcreator.coffeemachine.procedures.OpenGUI4Procedure;
import net.mcreator.coffeemachine.procedures.SCP294OnBlockRightClickedProcedure;
import net.mcreator.coffeemachine.world.inventory.CoffeeMachineGUI5Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CoffeeMachineGUI5ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public CoffeeMachineGUI5ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public CoffeeMachineGUI5ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(CoffeeMachineGUI5ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(CoffeeMachineGUI5ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            CoffeeMachineGUI5ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = CoffeeMachineGUI5Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenGUI4Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            SCP294OnBlockRightClickedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            GetMercuryProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            GetLiquidGoldProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            GetLoquidIronProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            GetLiquidHydrogenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            GetSupriseProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CoffeeMachineMod.addNetworkMessage(CoffeeMachineGUI5ButtonMessage.class, CoffeeMachineGUI5ButtonMessage::buffer, CoffeeMachineGUI5ButtonMessage::new, CoffeeMachineGUI5ButtonMessage::handler);
    }
}

