/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.coffeemachine.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.coffeemachine.CoffeeMachineMod;
import net.mcreator.coffeemachine.procedures.GetBeerProcedure;
import net.mcreator.coffeemachine.procedures.GetEnergyDrinkProcedure;
import net.mcreator.coffeemachine.procedures.GetJagermeisterProcedure;
import net.mcreator.coffeemachine.procedures.GetVodkaProcedure;
import net.mcreator.coffeemachine.procedures.GetWhiteMonsterProcedure;
import net.mcreator.coffeemachine.procedures.GetWineProcedure;
import net.mcreator.coffeemachine.procedures.OpenGUI2Procedure;
import net.mcreator.coffeemachine.procedures.OpenGUI4Procedure;
import net.mcreator.coffeemachine.world.inventory.CoffeeMachineGUI3Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CoffeeMachineGUI3ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public CoffeeMachineGUI3ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public CoffeeMachineGUI3ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(CoffeeMachineGUI3ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(CoffeeMachineGUI3ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            CoffeeMachineGUI3ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = CoffeeMachineGUI3Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenGUI2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenGUI4Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            GetEnergyDrinkProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            GetWhiteMonsterProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            GetBeerProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            GetJagermeisterProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            GetVodkaProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            GetWineProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CoffeeMachineMod.addNetworkMessage(CoffeeMachineGUI3ButtonMessage.class, CoffeeMachineGUI3ButtonMessage::buffer, CoffeeMachineGUI3ButtonMessage::new, CoffeeMachineGUI3ButtonMessage::handler);
    }
}

