/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.coffeemachine.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.coffeemachine.CoffeeMachineMod;
import net.mcreator.coffeemachine.procedures.GetColaProcedure;
import net.mcreator.coffeemachine.procedures.GetFantaProcedure;
import net.mcreator.coffeemachine.procedures.GetHotChocolateProcedure;
import net.mcreator.coffeemachine.procedures.GetSpeziProcedure;
import net.mcreator.coffeemachine.procedures.GetSpriteProcedure;
import net.mcreator.coffeemachine.procedures.GetTeaProcedure;
import net.mcreator.coffeemachine.procedures.OpenGUI3Procedure;
import net.mcreator.coffeemachine.procedures.SCP294OnBlockRightClickedProcedure;
import net.mcreator.coffeemachine.world.inventory.CoffeeMachineGUI2Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CoffeeMachineGUI2ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public CoffeeMachineGUI2ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public CoffeeMachineGUI2ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(CoffeeMachineGUI2ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(CoffeeMachineGUI2ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            CoffeeMachineGUI2ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = CoffeeMachineGUI2Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SCP294OnBlockRightClickedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenGUI3Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            GetTeaProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            GetHotChocolateProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            GetColaProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            GetSpriteProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            GetFantaProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            GetSpeziProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CoffeeMachineMod.addNetworkMessage(CoffeeMachineGUI2ButtonMessage.class, CoffeeMachineGUI2ButtonMessage::buffer, CoffeeMachineGUI2ButtonMessage::new, CoffeeMachineGUI2ButtonMessage::handler);
    }
}

