/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.network;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public interface INetworkHandler {
    public <T> void sendToServer(T var1);

    public <T> void sendToServer(T var1, boolean var2);

    public <T> void sendToClient(T var1, ServerPlayer var2);

    default public <T> void sendToClients(T packet, List<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            this.sendToClient(packet, player);
        }
    }

    default public <T> void sendToAllClients(T packet, MinecraftServer server) {
        this.sendToClients(packet, server.m_6846_().m_11314_());
    }

    default public <T> void sendToClientsInLevel(T packet, ServerLevel level) {
        this.sendToClients(packet, level.m_6907_());
    }

    default public <T> void sendToClientsLoadingChunk(T packet, LevelChunk chunk) {
        ServerChunkCache chunkCache = (ServerChunkCache)chunk.m_62953_().m_7726_();
        this.sendToClients(packet, chunkCache.f_8325_.m_183262_(chunk.m_7697_(), false));
    }

    default public <T> void sendToClientsLoadingPos(T packet, ServerLevel level, ChunkPos pos) {
        this.sendToClientsLoadingChunk(packet, level.m_6325_(pos.f_45578_, pos.f_45579_));
    }

    default public <T> void sendToClientsLoadingPos(T packet, ServerLevel level, BlockPos pos) {
        this.sendToClientsLoadingPos(packet, level, new ChunkPos(pos));
    }

    default public <T> void sendToClientsLoadingPos(T packet, ServerLevel level, Vec3 pos) {
        this.sendToClientsLoadingPos(packet, level, BlockPos.m_274446_((Position)pos));
    }

    default public <T> void sendToClientsInRange(T packet, ServerLevel level, BlockPos pos, double range) {
        for (ServerPlayer player : level.m_6907_()) {
            if (!(player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= range * range)) continue;
            this.sendToClient(packet, player);
        }
    }
}

