/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.network;

import com.cerbon.cerbons_api.api.network.Network;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class Dispatcher {
    public static <T> void sendToServer(T packet) {
        Network.getNetworkHandler().sendToServer(packet);
    }

    public static <T> void sendToServer(T packet, boolean ignoreCheck) {
        Network.getNetworkHandler().sendToServer(packet, ignoreCheck);
    }

    public static <T> void sendToClient(T packet, ServerPlayer player) {
        Network.getNetworkHandler().sendToClient(packet, player);
    }

    public static <T> void sendToClients(T packet, List<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            Dispatcher.sendToClient(packet, player);
        }
    }

    public static <T> void sendToAllClients(T packet, MinecraftServer server) {
        Dispatcher.sendToClients(packet, server.m_6846_().m_11314_());
    }

    public static <T> void sendToClientsInLevel(T packet, ServerLevel level) {
        Dispatcher.sendToClients(packet, level.m_6907_());
    }

    public static <T> void sendToClientsLoadingChunk(T packet, LevelChunk chunk) {
        ServerChunkCache chunkCache = (ServerChunkCache)chunk.m_62953_().m_7726_();
        Dispatcher.sendToClients(packet, chunkCache.f_8325_.m_183262_(chunk.m_7697_(), false));
    }

    public static <T> void sendToClientsLoadingPos(T packet, ServerLevel level, ChunkPos pos) {
        Dispatcher.sendToClientsLoadingChunk(packet, level.m_6325_(pos.f_45578_, pos.f_45579_));
    }

    public static <T> void sendToClientsLoadingPos(T packet, ServerLevel level, BlockPos pos) {
        Dispatcher.sendToClientsLoadingPos(packet, level, new ChunkPos(pos));
    }

    public static <T> void sendToClientsLoadingPos(T packet, ServerLevel level, Vec3 pos) {
        Dispatcher.sendToClientsLoadingPos(packet, level, BlockPos.m_274446_((Position)pos));
    }

    public static <T> void sendToClientsInRange(T packet, ServerLevel level, BlockPos pos, double range) {
        for (ServerPlayer player : level.m_6907_()) {
            if (!(player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= range * range)) continue;
            Dispatcher.sendToClient(packet, player);
        }
    }
}

