/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.inventory.container.modular.ModularGuiContainerMenu;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public abstract class ContainerBCTile<T extends TileBCore>
extends ModularGuiContainerMenu {
    public T tile;
    public Player player;

    public ContainerBCTile(@Nullable MenuType<?> type, int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        super(type, windowId, playerInv);
        this.player = playerInv.f_35978_;
        this.tile = (TileBCore)ContainerBCTile.getClientTile(playerInv, extraData);
    }

    public ContainerBCTile(@Nullable MenuType<?> type, int windowId, Inventory playerInv, T tile) {
        super(type, windowId, playerInv);
        this.player = playerInv.f_35978_;
        this.tile = tile;
        ((TileBCore)this.tile).onPlayerOpenContainer(playerInv.f_35978_);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        ((TileBCore)this.tile).onPlayerCloseContainer(player);
    }

    public void m_38946_() {
        super.m_38946_();
        ((TileBCore)this.tile).detectAndSendChanges(true);
    }

    public void m_38893_(ContainerListener listener) {
        super.m_38893_(listener);
        if (listener instanceof ServerPlayer) {
            ((TileBCore)this.tile).getDataManager().forcePlayerSync((ServerPlayer)listener);
        }
    }

    public boolean m_6875_(Player player) {
        if (this.tile.m_58904_().m_7702_(this.tile.m_58899_()) != this.tile) {
            return false;
        }
        return player.m_20275_((double)this.tile.m_58899_().m_123341_() + 0.5, (double)this.tile.m_58899_().m_123342_() + 0.5, (double)this.tile.m_58899_().m_123343_() + 0.5) <= (double)((TileBCore)this.tile).getAccessDistanceSq();
    }

    public Slot m_38853_(int slotId) {
        if (slotId < this.f_38839_.size() && slotId >= 0) {
            return (Slot)this.f_38839_.get(slotId);
        }
        return null;
    }

    @Deprecated
    public LazyOptional<IItemHandler> getItemHandler() {
        return ((TileBCore)this.tile).getCapability(ForgeCapabilities.ITEM_HANDLER, null);
    }

    protected static <T extends BlockEntity> T getClientTile(Inventory playerInv, FriendlyByteBuf extraData) {
        return (T)playerInv.f_35978_.m_9236_().m_7702_(extraData.m_130135_());
    }

    public PacketCustom createServerBoundPacket(int packetType) {
        PacketCustom packet = new PacketCustom(BCoreNetwork.CHANNEL, packetType);
        packet.writeInt(this.f_38840_);
        return packet;
    }

    public void handleContainerMessage(PacketCustom packet, ServerPlayer player) {
        int containerId = packet.readInt();
        if (containerId != this.f_38840_) {
            return;
        }
        byte packetID = packet.readByte();
        ((TileBCore)this.tile).receivePacketFromClient((MCDataInput)packet, player, packetID);
    }

    public void handleTileDataPacket(PacketCustom packet, ServerPlayer player) {
        int containerId = packet.readInt();
        if (containerId != this.f_38840_) {
            return;
        }
        ((TileBCore)this.tile).getDataManager().receiveDataFromClient((MCDataInput)packet);
    }
}

